/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.value.bigdecimal;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;
import org.apache.isis.core.progmodel.facets.value.bigdecimal.BigDecimalValueFacet;

public class BigDecimalValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<BigDecimal>
implements BigDecimalValueFacet {
    private static final int TYPICAL_LENGTH = 10;
    private static final BigDecimal DEFAULT_VALUE = new BigDecimal(0);
    public static final int DEFAULT_LENGTH = 18;
    public static final int DEFAULT_SCALE = 2;
    private final NumberFormat format = this.determineNumberFormat("value.format.decimal");

    private static Class<? extends Facet> type() {
        return BigDecimalValueFacet.class;
    }

    public BigDecimalValueSemanticsProvider() {
        this((FacetHolder)null, (IsisConfiguration)null, (ValueSemanticsProviderContext)null);
    }

    public BigDecimalValueSemanticsProvider(FacetHolder holder, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(BigDecimalValueSemanticsProvider.type(), holder, BigDecimal.class, 10, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, DEFAULT_VALUE, configuration, context);
    }

    public void setLocale(Locale l) {
    }

    @Override
    @Deprecated
    public Integer getLength() {
        return this.getPrecision();
    }

    @Override
    public Integer getPrecision() {
        return 18;
    }

    @Override
    public Integer getScale() {
        return 2;
    }

    @Override
    protected BigDecimal doParse(Object context, String entry) {
        try {
            return new BigDecimal(entry);
        }
        catch (NumberFormatException e) {
            throw new TextEntryParseException("Not an decimal " + entry, e);
        }
    }

    @Override
    public String titleString(Object object, Localization localization) {
        return this.titleString(this.format, object);
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(new DecimalFormat(usingMask), value);
    }

    @Override
    protected String doEncode(Object object) {
        try {
            Class<?> type = object.getClass();
            try {
                return (String)type.getMethod("toPlainString", null).invoke(object, (Object[])null);
            }
            catch (NoSuchMethodException nsm) {
                return (String)type.getMethod("toString", null).invoke(object, (Object[])null);
            }
        }
        catch (Exception e) {
            throw new IsisException(e);
        }
    }

    @Override
    protected BigDecimal doRestore(String data) {
        return new BigDecimal(data);
    }

    @Override
    public String toString() {
        return "BigDecimalValueSemanticsProvider: " + this.format;
    }
}

