/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.value.clobs;

import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.isis.applib.adapters.DefaultsProvider;
import org.apache.isis.applib.adapters.Parser;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;
import org.apache.isis.core.progmodel.facets.value.clobs.ClobValueFacet;

public class ClobValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<Clob>
implements ClobValueFacet {
    private static final int TYPICAL_LENGTH = 0;
    private static final Clob DEFAULT_VALUE = null;

    private static Class<? extends Facet> type() {
        return ClobValueFacet.class;
    }

    public ClobValueSemanticsProvider() {
        this((FacetHolder)null, (IsisConfiguration)null, (ValueSemanticsProviderContext)null);
    }

    public ClobValueSemanticsProvider(FacetHolder holder, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(ClobValueSemanticsProvider.type(), holder, Clob.class, 0, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.NOT_HONOURED, DEFAULT_VALUE, configuration, context);
    }

    @Override
    public String titleString(Object object, Localization localization) {
        return object != null ? ((Clob)object).getName() : "[null]";
    }

    @Override
    public String titleStringWithMask(Object value, String usingMask) {
        return this.titleString(value, null);
    }

    @Override
    public Parser<Clob> getParser() {
        return null;
    }

    @Override
    public DefaultsProvider<Clob> getDefaultsProvider() {
        return null;
    }

    @Override
    protected String doEncode(Object object) {
        Clob clob = (Clob)object;
        return clob.getName() + ":" + clob.getMimeType().getBaseType() + ":" + clob.getChars();
    }

    @Override
    protected Clob doRestore(String data) {
        int colonIdx = data.indexOf(58);
        String name = data.substring(0, colonIdx);
        int colon2Idx = data.indexOf(":", colonIdx + 1);
        String mimeTypeBase = data.substring(colonIdx + 1, colon2Idx);
        String chars = data.substring(colon2Idx + 1);
        try {
            return new Clob(name, new MimeType(mimeTypeBase), (CharSequence)chars);
        }
        catch (MimeTypeParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        return "ClobValueSemanticsProvider";
    }
}

