/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.value.color;

import java.text.DecimalFormat;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.applib.value.Color;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facets.object.parseable.TextEntryParseException;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;
import org.apache.isis.core.progmodel.facets.value.color.ColorValueFacet;

public class ColorValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<Color>
implements ColorValueFacet {
    private static final Color DEFAULT_VALUE = Color.BLACK;
    private static final int TYPICAL_LENGTH = 4;

    public static Class<? extends Facet> type() {
        return ColorValueFacet.class;
    }

    public ColorValueSemanticsProvider() {
        this((FacetHolder)null, (IsisConfiguration)null, (ValueSemanticsProviderContext)null);
    }

    public ColorValueSemanticsProvider(FacetHolder holder, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(ColorValueSemanticsProvider.type(), holder, Color.class, 4, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.NOT_HONOURED, DEFAULT_VALUE, configuration, context);
    }

    @Override
    protected Color doParse(Object context, String text) {
        try {
            if (text.startsWith("0x")) {
                return new Color(Integer.parseInt(text.substring(2), 16));
            }
            if (text.startsWith("#")) {
                return new Color(Integer.parseInt(text.substring(1), 16));
            }
            return new Color(Integer.parseInt(text));
        }
        catch (NumberFormatException e) {
            throw new TextEntryParseException("Not a number " + text, e);
        }
    }

    @Override
    public String titleString(Object object, Localization localization) {
        Color color = (Color)object;
        return color.title();
    }

    @Override
    public String titleStringWithMask(Object object, String usingMask) {
        Color color = (Color)object;
        return this.titleString(new DecimalFormat(usingMask), color.intValue());
    }

    @Override
    protected String doEncode(Object object) {
        Color color = (Color)object;
        return Integer.toHexString(color.intValue());
    }

    @Override
    protected Color doRestore(String data) {
        return new Color(Integer.parseInt(data, 16));
    }

    @Override
    public int colorValue(ObjectAdapter object) {
        if (object == null) {
            return 0;
        }
        Color color = (Color)object.getObject();
        return color.intValue();
    }

    @Override
    public ObjectAdapter createValue(ObjectAdapter object, int colorAsInt) {
        Color color = new Color(colorAsInt);
        return this.getAdapterManager().adapterFor(color);
    }

    @Override
    public String toString() {
        return "ColorValueSemanticsProvider";
    }
}

