/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.progmodel.facets.value.url;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.isis.applib.profiles.Localization;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderAndFacetAbstract;
import org.apache.isis.core.progmodel.facets.object.value.ValueSemanticsProviderContext;
import org.apache.isis.core.progmodel.facets.value.url.URLValueFacet;

public class URLValueSemanticsProvider
extends ValueSemanticsProviderAndFacetAbstract<URL>
implements URLValueFacet {
    private static final int TYPICAL_LENGTH = 100;
    private static final URL DEFAULT_VALUE = null;

    public static Class<? extends Facet> type() {
        return URLValueFacet.class;
    }

    public URLValueSemanticsProvider() {
        this((FacetHolder)null, (IsisConfiguration)null, (ValueSemanticsProviderContext)null);
    }

    public URLValueSemanticsProvider(FacetHolder holder, IsisConfiguration configuration, ValueSemanticsProviderContext context) {
        super(URLValueSemanticsProvider.type(), holder, URL.class, 100, ValueSemanticsProviderAndFacetAbstract.Immutability.IMMUTABLE, ValueSemanticsProviderAndFacetAbstract.EqualByContent.HONOURED, DEFAULT_VALUE, configuration, context);
    }

    @Override
    protected URL doParse(Object context, String entry) {
        if (entry.trim().equals("")) {
            return null;
        }
        try {
            return new URL(entry);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Not parseable as a URL ('" + entry + "')", ex);
        }
    }

    @Override
    public String titleString(Object object, Localization localization) {
        return object != null ? object.toString() : "";
    }

    @Override
    public String titleStringWithMask(Object object, String usingMask) {
        return this.titleString(object, null);
    }

    @Override
    protected String doEncode(Object object) {
        URL url = (URL)object;
        return url != null ? url.toString() : "NULL";
    }

    @Override
    protected URL doRestore(String data) {
        if ("NULL".equals(data)) {
            return null;
        }
        try {
            return new URL(data);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public URL urlValue(ObjectAdapter object) {
        return object == null ? null : (URL)object.getObject();
    }

    @Override
    public ObjectAdapter createValue(URL value) {
        return this.getAdapterManager().adapterFor(value);
    }

    @Override
    public String toString() {
        return "URLValueSemanticsProvider";
    }
}

