/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.userprofile;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;

public class Options
implements DebuggableWithTitle {
    private final Properties properties = new Properties();

    public void addOption(String name, String value) {
        this.properties.put(name, value);
    }

    public void addOptions(String name, Options options) {
        this.properties.put(name, options);
    }

    public Iterator<String> names() {
        final Enumeration<?> propertyNames = this.properties.propertyNames();
        return new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return propertyNames.hasMoreElements();
            }

            @Override
            public String next() {
                return (String)propertyNames.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public String getString(String name) {
        return this.properties.getProperty(name);
    }

    public String getString(String name, String defaultValue) {
        return this.properties.getProperty(name, defaultValue);
    }

    public int getInteger(String name, int defaultValue) {
        String value = this.getString(name);
        if (value == null) {
            return defaultValue;
        }
        return Integer.valueOf(value);
    }

    public Options getOptions(String name) {
        Options options = (Options)this.properties.get(name);
        if (options == null) {
            options = new Options();
            this.addOptions(name, options);
        }
        return options;
    }

    public boolean isOptions(String name) {
        return this.properties.get(name) instanceof Options;
    }

    public void copy(Options options) {
        this.properties.putAll((Map<?, ?>)options.properties);
    }

    @Override
    public String debugTitle() {
        return "Options";
    }

    @Override
    public void debugData(DebugBuilder debug) {
        Enumeration<Object> keys = this.properties.keys();
        while (keys.hasMoreElements()) {
            String name = (String)keys.nextElement();
            debug.appendln(name, this.properties.get(name));
        }
    }
}

