/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp.routing;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectToDocsFilter
implements Filter {
    private static final Logger LOG = LoggerFactory.getLogger(RedirectToDocsFilter.class);
    private static final String REDIRECT_TO_KEY = "redirectTo";
    private static final String REDIRECT_TO_DEFAULT = "/index.html";
    private static final String ACCEPT_HEADER = "Accept";
    private static final String APPLICATION_JSON_MIME_TYPE = "application/json";
    private String redirectTo;

    public void init(FilterConfig cfg) throws ServletException {
        this.redirectTo = cfg.getInitParameter(REDIRECT_TO_KEY);
        if (this.redirectTo == null) {
            this.redirectTo = REDIRECT_TO_DEFAULT;
        }
        System.out.println("redirectToDocsFilter: redirectTo=" + this.redirectTo);
        LOG.info("redirectToDocsFilter: redirectTo=" + this.redirectTo);
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        String servletPath = httpServletRequest.getServletPath();
        System.out.println("redirectToDocsFilter: servletPath: " + servletPath);
        LOG.info("redirectToDocsFilter: servletPath: " + servletPath);
        if (!"/".equals(servletPath)) {
            chain.doFilter(request, response);
            return;
        }
        String acceptHeader = httpServletRequest.getHeader(ACCEPT_HEADER);
        if (acceptHeader != null && acceptHeader.startsWith(APPLICATION_JSON_MIME_TYPE)) {
            chain.doFilter(request, response);
            return;
        }
        String redirect = RedirectToDocsFilter.combine(httpServletRequest.getContextPath(), this.redirectTo);
        System.out.println("redirectToDocsFilter: redirecting to: " + redirect);
        LOG.info("redirectToDocsFilter: redirecting to: " + redirect);
        httpServletResponse.sendRedirect(redirect);
    }

    private static String combine(String str1, String str2) {
        StringBuilder buf = new StringBuilder(str1);
        if (!str2.startsWith("/")) {
            buf.append("/");
        }
        buf.append(str2);
        return buf.toString();
    }
}

