/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.objectstore;

import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebugUtils;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.adapter.oid.TypedOid;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.objectstore.InMemoryPersistenceSessionFactory;
import org.apache.isis.core.objectstore.commands.InMemoryCreateObjectCommand;
import org.apache.isis.core.objectstore.commands.InMemoryDestroyObjectCommand;
import org.apache.isis.core.objectstore.commands.InMemorySaveObjectCommand;
import org.apache.isis.core.objectstore.internal.ObjectStoreInstances;
import org.apache.isis.core.objectstore.internal.ObjectStorePersistedObjects;
import org.apache.isis.core.objectstore.internal.ObjectStorePersistedObjectsDefault;
import org.apache.isis.core.runtime.persistence.ObjectNotFoundException;
import org.apache.isis.core.runtime.persistence.ObjectPersistenceException;
import org.apache.isis.core.runtime.persistence.UnsupportedFindException;
import org.apache.isis.core.runtime.persistence.objectstore.ObjectStoreSpi;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.PersistenceCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.SaveObjectCommand;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryBuiltIn;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceQuery;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InMemoryObjectStore
implements ObjectStoreSpi {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryObjectStore.class);
    protected ObjectStorePersistedObjects persistedObjects;

    public InMemoryObjectStore() {
        LOG.info("creating memory object store");
    }

    public String name() {
        return "In-Memory Object Store";
    }

    public void open() {
        InMemoryPersistenceSessionFactory inMemoryPersistenceSessionFactory = this.getInMemoryPersistenceSessionFactory();
        ObjectStorePersistedObjects objectStorePersistedObjects = this.persistedObjects = inMemoryPersistenceSessionFactory == null ? null : inMemoryPersistenceSessionFactory.getPersistedObjects();
        if (this.persistedObjects == null) {
            this.persistedObjects = inMemoryPersistenceSessionFactory != null ? inMemoryPersistenceSessionFactory.createPersistedObjects() : new ObjectStorePersistedObjectsDefault();
        } else {
            this.recreateAdapters();
        }
    }

    protected void recreateAdapters() {
        for (ObjectSpecification noSpec : this.persistedObjects.specifications()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("recreating adapters for: " + noSpec.getFullIdentifier());
            }
            this.recreateAdapters(this.persistedObjects.instancesFor(noSpec));
        }
    }

    private void recreateAdapters(ObjectStoreInstances objectStoreInstances) {
        for (Oid oid : objectStoreInstances.getOids()) {
            ObjectAdapter existingAdapterLookedUpByOid;
            if (LOG.isDebugEnabled()) {
                LOG.debug("recreating adapter: oid=" + oid);
            }
            Object pojo = objectStoreInstances.getPojo(oid);
            ObjectAdapter existingAdapterLookedUpByPojo = this.getAdapterManager().getAdapterFor(pojo);
            if (existingAdapterLookedUpByPojo != null) {
                this.getPersistenceSession().removeAdapter(existingAdapterLookedUpByPojo);
            }
            if ((existingAdapterLookedUpByOid = this.getAdapterManager().getAdapterFor(oid)) != null) {
                throw new IsisException("A mapping already exists for " + oid + ": " + existingAdapterLookedUpByOid);
            }
            ObjectAdapter recreatedAdapter = this.getPersistenceSession().mapRecreatedPojo(oid, pojo);
            Version version = objectStoreInstances.getVersion(oid);
            recreatedAdapter.setVersion(version);
        }
    }

    public void close() {
        InMemoryPersistenceSessionFactory inMemoryPersistenceSessionFactory = this.getInMemoryPersistenceSessionFactory();
        if (inMemoryPersistenceSessionFactory != null) {
            inMemoryPersistenceSessionFactory.attach(this.getPersistenceSession(), this.persistedObjects);
            this.persistedObjects = null;
        }
    }

    public boolean isFixturesInstalled() {
        return false;
    }

    public void reset() {
    }

    public void startTransaction() {
    }

    public void endTransaction() {
    }

    public void abortTransaction() {
    }

    public CreateObjectCommand createCreateObjectCommand(ObjectAdapter object) {
        if (object.getSpecification().isParented()) {
            return null;
        }
        return new InMemoryCreateObjectCommand(object, this.persistedObjects);
    }

    public SaveObjectCommand createSaveObjectCommand(ObjectAdapter object) {
        if (object.getSpecification().isParented()) {
            return null;
        }
        return new InMemorySaveObjectCommand(object, this.persistedObjects);
    }

    public DestroyObjectCommand createDestroyObjectCommand(ObjectAdapter object) {
        return new InMemoryDestroyObjectCommand(object, this.persistedObjects);
    }

    public void execute(List<PersistenceCommand> commands) throws ObjectPersistenceException {
        if (LOG.isInfoEnabled()) {
            LOG.info("execute commands");
        }
        for (PersistenceCommand command : commands) {
            command.execute(null);
        }
        LOG.info("end execution");
    }

    public ObjectAdapter loadInstanceAndAdapt(TypedOid oid) throws ObjectNotFoundException, ObjectPersistenceException {
        ObjectSpecification objectSpec;
        ObjectStoreInstances ins;
        ObjectAdapter adapter;
        if (LOG.isDebugEnabled()) {
            LOG.debug("getObject " + oid);
        }
        if ((adapter = (ins = this.instancesFor(objectSpec = this.getSpecificationLookup().lookupBySpecId(oid.getObjectSpecId()))).getObjectAndMapIfRequired((Oid)oid)) == null) {
            throw new ObjectNotFoundException((Oid)oid);
        }
        return adapter;
    }

    public void resolveImmediately(ObjectAdapter adapter) throws ObjectPersistenceException {
        if (adapter.canTransitionToResolving()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("resolve " + adapter);
            }
        } else {
            LOG.warn("resolveImmediately ignored, adapter's current state is: " + adapter.getResolveState() + " ; oid: " + adapter.getOid());
        }
        adapter.markAsResolvedIfPossible();
    }

    public void resolveField(ObjectAdapter object, ObjectAssociation field) throws ObjectPersistenceException {
        ObjectAdapter referenceAdapter = field.get(object);
        referenceAdapter.markAsResolvedIfPossible();
    }

    public List<ObjectAdapter> loadInstancesAndAdapt(PersistenceQuery persistenceQuery) throws ObjectPersistenceException, UnsupportedFindException {
        if (!(persistenceQuery instanceof PersistenceQueryBuiltIn)) {
            throw new IllegalArgumentException(MessageFormat.format("Provided PersistenceQuery not supported; was {0}; the in-memory object store only supports {1}", persistenceQuery.getClass().getName(), PersistenceQueryBuiltIn.class.getName()));
        }
        PersistenceQueryBuiltIn builtIn = (PersistenceQueryBuiltIn)persistenceQuery;
        ArrayList instances = Lists.newArrayList();
        ObjectSpecification spec = persistenceQuery.getSpecification();
        this.findInstances(spec, builtIn, instances);
        return InMemoryObjectStore.resolved(instances);
    }

    public boolean hasInstances(ObjectSpecification spec) {
        if (this.instancesFor(spec).hasInstances()) {
            return true;
        }
        List subclasses = spec.subclasses();
        for (int i = 0; i < subclasses.size(); ++i) {
            if (!this.hasInstances((ObjectSpecification)subclasses.get(i))) continue;
            return true;
        }
        return false;
    }

    private void findInstances(ObjectSpecification spec, PersistenceQueryBuiltIn persistenceQuery, List<ObjectAdapter> foundInstances) {
        this.instancesFor(spec).findInstancesAndAdd(persistenceQuery, foundInstances);
        List subclasses = spec.subclasses();
        for (int i = 0; i < subclasses.size(); ++i) {
            this.findInstances((ObjectSpecification)subclasses.get(i), persistenceQuery, foundInstances);
        }
    }

    private static List<ObjectAdapter> resolved(List<ObjectAdapter> instances) {
        for (ObjectAdapter adapter : instances) {
            adapter.markAsResolvedIfPossible();
        }
        return instances;
    }

    public RootOid getOidForService(ObjectSpecification serviceSpec) {
        return (RootOid)this.persistedObjects.getService(serviceSpec.getSpecId());
    }

    public void registerService(RootOid rootOid) {
        this.persistedObjects.registerService(rootOid.getObjectSpecId(), (Oid)rootOid);
    }

    private ObjectStoreInstances instancesFor(ObjectSpecification spec) {
        return this.persistedObjects.instancesFor(spec);
    }

    public String debugTitle() {
        return this.name();
    }

    public void debugData(DebugBuilder debug) {
        debug.appendTitle("Domain Objects");
        for (ObjectSpecification spec : this.persistedObjects.specifications()) {
            debug.appendln(spec.getFullIdentifier());
            ObjectStoreInstances instances = this.instancesFor(spec);
            instances.debugData(debug);
        }
        debug.unindent();
        debug.appendln();
    }

    private String debugCollectionGraph(ObjectAdapter collection, int level, Vector<ObjectAdapter> recursiveElements) {
        StringBuffer s = new StringBuffer();
        if (recursiveElements.contains(collection)) {
            s.append("*\n");
        } else {
            recursiveElements.addElement(collection);
            CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((ObjectAdapter)collection);
            Iterator e = facet.iterator(collection);
            while (e.hasNext()) {
                ObjectAdapter element;
                this.indent(s, level);
                try {
                    element = (ObjectAdapter)e.next();
                }
                catch (ClassCastException ex) {
                    LOG.error(ex.getMessage(), (Throwable)ex);
                    return s.toString();
                }
                s.append(element);
                s.append(this.debugGraph(element, level + 1, recursiveElements));
            }
        }
        return s.toString();
    }

    private String debugGraph(ObjectAdapter object, int level, Vector<ObjectAdapter> recursiveElements) {
        if (level > 3) {
            return "...\n";
        }
        Vector<Object> elements = recursiveElements == null ? new Vector(25, 10) : recursiveElements;
        if (object.getSpecification().isParentedOrFreeCollection()) {
            return "\n" + this.debugCollectionGraph(object, level, elements);
        }
        return "\n" + this.debugObjectGraph(object, level, elements);
    }

    private String debugObjectGraph(ObjectAdapter object, int level, Vector<ObjectAdapter> recursiveElements) {
        StringBuffer s = new StringBuffer();
        recursiveElements.addElement(object);
        List fields = object.getSpecification().getAssociations(Contributed.EXCLUDED);
        for (int i = 0; i < fields.size(); ++i) {
            ObjectAssociation field = (ObjectAssociation)fields.get(i);
            ObjectAdapter obj = field.get(object);
            String id = field.getId();
            this.indent(s, level);
            if (field.isOneToManyAssociation()) {
                s.append(id + ": \n" + this.debugCollectionGraph(obj, level + 1, recursiveElements));
                continue;
            }
            if (recursiveElements.contains(obj)) {
                s.append(id + ": " + obj + "*\n");
                continue;
            }
            s.append(id + ": " + obj);
            s.append(this.debugGraph(obj, level + 1, recursiveElements));
        }
        return s.toString();
    }

    private void indent(StringBuffer s, int level) {
        for (int indent = 0; indent < level; ++indent) {
            s.append(DebugUtils.indentString((int)4) + "|");
        }
        s.append(DebugUtils.indentString((int)4) + "+--");
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    protected SpecificationLoader getSpecificationLookup() {
        return IsisContext.getSpecificationLoader();
    }

    protected InMemoryPersistenceSessionFactory getInMemoryPersistenceSessionFactory() {
        PersistenceSessionFactory persistenceSessionFactory = this.getPersistenceSession().getPersistenceSessionFactory();
        if (!(persistenceSessionFactory instanceof InMemoryPersistenceSessionFactory)) {
            return null;
        }
        return (InMemoryPersistenceSessionFactory)persistenceSessionFactory;
    }
}

