/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.objectstore;

import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.objectstore.internal.ObjectStoreInstances;
import org.apache.isis.core.objectstore.internal.ObjectStorePersistedObjects;
import org.apache.isis.core.objectstore.internal.ObjectStorePersistedObjectsDefault;
import org.apache.isis.core.runtime.persistence.PersistenceSessionFactoryDelegate;
import org.apache.isis.core.runtime.persistence.PersistenceSessionFactoryDelegating;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.persistence.IdentifierGenerator;
import org.apache.isis.core.runtime.system.persistence.IdentifierGeneratorDefault;
import org.apache.isis.core.runtime.system.persistence.OidGenerator;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;

public class InMemoryPersistenceSessionFactory
extends PersistenceSessionFactoryDelegating {
    private ObjectStorePersistedObjects persistedObjects;

    public InMemoryPersistenceSessionFactory(DeploymentType deploymentType, IsisConfiguration configuration, PersistenceSessionFactoryDelegate persistenceSessionFactoryDelegate) {
        super(deploymentType, configuration, persistenceSessionFactoryDelegate);
    }

    ObjectStorePersistedObjects getPersistedObjects() {
        return this.persistedObjects;
    }

    public PersistenceSession createPersistenceSession() {
        OidGenerator oidGenerator;
        IdentifierGenerator identifierGenerator;
        PersistenceSession persistenceSession = super.createPersistenceSession();
        if (this.persistedObjects != null && (identifierGenerator = (oidGenerator = persistenceSession.getOidGenerator()).getIdentifierGenerator()) instanceof IdentifierGeneratorDefault) {
            IdentifierGeneratorDefault identifierGeneratorDefault = (IdentifierGeneratorDefault)identifierGenerator;
            identifierGeneratorDefault.resetTo(this.persistedObjects.getOidGeneratorMemento());
        }
        return persistenceSession;
    }

    public ObjectStorePersistedObjects createPersistedObjects() {
        return new ObjectStorePersistedObjectsDefault();
    }

    public void attach(PersistenceSession persistenceSession, ObjectStorePersistedObjects persistedObjects) {
        OidGenerator oidGenerator = persistenceSession.getOidGenerator();
        IdentifierGenerator identifierGenerator = oidGenerator.getIdentifierGenerator();
        if (identifierGenerator instanceof IdentifierGeneratorDefault) {
            IdentifierGeneratorDefault identifierGeneratorDefault = (IdentifierGeneratorDefault)identifierGenerator;
            persistedObjects.saveOidGeneratorMemento(identifierGeneratorDefault.getMemento());
        }
        this.persistedObjects = persistedObjects;
    }

    protected void doShutdown() {
        if (this.persistedObjects != null) {
            for (ObjectStoreInstances inst : this.persistedObjects.instances()) {
                inst.shutdown();
            }
            this.persistedObjects.clear();
        }
    }
}

