/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.objectstore.commands;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.objectstore.internal.ObjectStoreInstances;
import org.apache.isis.core.objectstore.internal.ObjectStorePersistedObjects;
import org.apache.isis.core.runtime.persistence.ObjectPersistenceException;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.PersistenceCommandAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInMemoryPersistenceCommand
extends PersistenceCommandAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractInMemoryPersistenceCommand.class);
    private final ObjectStorePersistedObjects persistedObjects;

    public AbstractInMemoryPersistenceCommand(ObjectAdapter adapter, ObjectStorePersistedObjects persistedObjects) {
        super(adapter);
        this.persistedObjects = persistedObjects;
    }

    protected void save(ObjectAdapter adapter) throws ObjectPersistenceException {
        ObjectSpecification specification = adapter.getSpecification();
        if (LOG.isDebugEnabled()) {
            LOG.debug("   saving object " + adapter + " as instance of " + specification.getShortIdentifier());
        }
        ObjectStoreInstances ins = this.instancesFor(specification);
        ins.save(adapter);
    }

    protected void destroy(ObjectAdapter adapter) {
        ObjectSpecification specification = adapter.getSpecification();
        if (LOG.isDebugEnabled()) {
            LOG.debug("   destroy object " + adapter + " as instance of " + specification.getShortIdentifier());
        }
        ObjectStoreInstances ins = this.instancesFor(specification);
        ins.remove(adapter.getOid());
    }

    private ObjectStoreInstances instancesFor(ObjectSpecification spec) {
        return this.persistedObjects.instancesFor(spec);
    }
}

