/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.objectstore.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.version.SerialNumberVersion;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryBuiltIn;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;

public class ObjectStoreInstances {
    private final Map<Oid, Object> pojoByOidMap = new HashMap<Oid, Object>();
    private final Map<Oid, Version> versionByOidMap = new HashMap<Oid, Version>();
    private final ObjectSpecification spec;

    public ObjectStoreInstances(ObjectSpecification spec) {
        this.spec = spec;
    }

    public Map<Oid, Object> getObjectInstances() {
        return this.pojoByOidMap;
    }

    public Set<Oid> getOids() {
        return Collections.unmodifiableSet(this.pojoByOidMap.keySet());
    }

    public Object getPojo(Oid oid) {
        return this.pojoByOidMap.get(oid);
    }

    public Version getVersion(Oid oid) {
        return this.versionByOidMap.get(oid);
    }

    public void shutdown() {
        this.pojoByOidMap.clear();
        this.versionByOidMap.clear();
    }

    public void save(ObjectAdapter adapter) {
        this.pojoByOidMap.put(adapter.getOid(), adapter.getObject());
        Version version = this.versionByOidMap.get(adapter.getOid());
        Version nextVersion = this.nextVersion(version);
        this.versionByOidMap.put(adapter.getOid(), nextVersion);
        adapter.setVersion(nextVersion);
    }

    private synchronized Version nextVersion(Version version) {
        long sequence = (version != null ? version.getSequence() : 0L) + 1L;
        return SerialNumberVersion.create((long)sequence, (String)this.getAuthenticationSession().getUserName(), (Date)new Date(Clock.getTime()));
    }

    public void remove(Oid oid) {
        this.pojoByOidMap.remove(oid);
        this.versionByOidMap.remove(oid);
    }

    public ObjectAdapter getObjectAndMapIfRequired(Oid oid) {
        Object pojo = this.getObjectInstances().get(oid);
        if (pojo == null) {
            return null;
        }
        ObjectAdapter adapterLookedUpByPojo = this.getAdapterManager().getAdapterFor(pojo);
        if (adapterLookedUpByPojo != null) {
            return adapterLookedUpByPojo;
        }
        ObjectAdapter adapterLookedUpByOid = this.getAdapterManager().getAdapterFor(oid);
        if (adapterLookedUpByOid != null) {
            return adapterLookedUpByOid;
        }
        return this.getPersistenceSession().mapRecreatedPojo(oid, pojo);
    }

    public void findInstancesAndAdd(PersistenceQueryBuiltIn persistenceQuery, List<ObjectAdapter> foundInstances) {
        for (ObjectAdapter element : this.elements()) {
            if (!persistenceQuery.matches(element)) continue;
            foundInstances.add(element);
        }
    }

    public int numberOfInstances() {
        return this.getObjectInstances().size();
    }

    public boolean hasInstances() {
        return this.numberOfInstances() > 0;
    }

    private List<ObjectAdapter> elements() {
        ArrayList<ObjectAdapter> v = new ArrayList<ObjectAdapter>(this.getObjectInstances().size());
        for (Oid oid : this.getObjectInstances().keySet()) {
            v.add(this.getObjectAndMapIfRequired(oid));
        }
        return v;
    }

    public void debugData(DebugBuilder debug) {
        debug.indent();
        if (this.getObjectInstances().size() == 0) {
            debug.appendln("no instances");
        }
        for (Oid oid : this.getObjectInstances().keySet()) {
            ObjectAdapter objectAdapter = this.getObjectAndMapIfRequired(oid);
            String title = objectAdapter.titleString();
            Object object = this.getObjectInstances().get(oid);
            debug.appendln(oid.toString(), (Object)(object + " (" + title + ")"));
        }
        debug.appendln();
        debug.unindent();
    }

    protected PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected AdapterManager getAdapterManager() {
        return this.getPersistenceSession().getAdapterManager();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return IsisContext.getAuthenticationSession();
    }
}

