/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.objectstore.internal;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.spec.ObjectSpecId;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.objectstore.internal.ObjectStoreInstances;
import org.apache.isis.core.objectstore.internal.ObjectStorePersistedObjects;
import org.apache.isis.core.runtime.system.persistence.IdentifierGeneratorDefault;

public class ObjectStorePersistedObjectsDefault
implements ObjectStorePersistedObjects {
    private final Map<ObjectSpecification, ObjectStoreInstances> instancesBySpecMap = Maps.newHashMap();
    private final Map<ObjectSpecId, Oid> serviceOidByIdMap = Maps.newHashMap();
    private IdentifierGeneratorDefault.Memento oidGeneratorMemento;

    @Override
    public IdentifierGeneratorDefault.Memento getOidGeneratorMemento() {
        return this.oidGeneratorMemento;
    }

    @Override
    public void saveOidGeneratorMemento(IdentifierGeneratorDefault.Memento memento) {
        this.oidGeneratorMemento = memento;
    }

    @Override
    public Oid getService(ObjectSpecId objectSpecId) {
        return this.serviceOidByIdMap.get(objectSpecId);
    }

    @Override
    public void registerService(ObjectSpecId objectSpecId, Oid oid) {
        Oid oidLookedUpByName = this.serviceOidByIdMap.get(objectSpecId);
        if (oidLookedUpByName != null) {
            if (oidLookedUpByName.equals(oid)) {
                throw new IsisException("Already another service registered as name: " + objectSpecId + " (existing Oid: " + oidLookedUpByName + ", " + "intended: " + oid + ")");
            }
        } else {
            this.serviceOidByIdMap.put(objectSpecId, oid);
        }
    }

    @Override
    public ObjectStoreInstances instancesFor(ObjectSpecification spec) {
        ObjectStoreInstances ins = this.instancesBySpecMap.get(spec);
        if (ins == null) {
            ins = new ObjectStoreInstances(spec);
            this.instancesBySpecMap.put(spec, ins);
        }
        return ins;
    }

    @Override
    public Iterable<ObjectSpecification> specifications() {
        return this.instancesBySpecMap.keySet();
    }

    @Override
    public void clear() {
        this.instancesBySpecMap.clear();
    }

    @Override
    public Iterable<ObjectStoreInstances> instances() {
        return this.instancesBySpecMap.values();
    }
}

