/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.fixturedomainservice;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacet;
import org.apache.isis.core.metamodel.facets.collections.modify.CollectionFacetUtils;
import org.apache.isis.core.metamodel.facets.object.parseable.ParseableFacet;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.ObjectSpecificationException;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.fixturedomainservice.FixtureException;
import org.apache.isis.core.runtime.fixturedomainservice.LoadedObjects;
import org.apache.isis.core.runtime.fixturedomainservice.SavedObjects;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectFixtureFilePersistor {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectFixtureFilePersistor.class);
    @Inject
    IsisSessionFactory isisSessionFactory;
    @Inject
    SpecificationLoader specificationLoader;

    public Set<Object> loadData(Reader reader) throws IOException {
        HashSet<Object> objects = new HashSet<Object>();
        BufferedReader buffer = new BufferedReader(reader);
        LoadedObjects loaded = new LoadedObjects(objects, this.specificationLoader, this.getPersistenceSession());
        ObjectAdapter object = null;
        int lineNo = 0;
        try {
            String line;
            while ((line = buffer.readLine()) != null) {
                ++lineNo;
                if (line.trim().startsWith("#")) continue;
                if (line.startsWith("  ")) {
                    this.loadFieldData(object, loaded, line);
                    continue;
                }
                if (object != null && !object.representsPersistent()) {
                    this.getPersistenceSession().makePersistentInTransaction(object);
                }
                object = loaded.get(line);
            }
            if (object != null && !object.representsPersistent()) {
                this.getPersistenceSession().makePersistentInTransaction(object);
            }
        }
        catch (Exception e) {
            throw new FixtureException("failed to load data at line " + lineNo, e);
        }
        return objects;
    }

    private void loadFieldData(ObjectAdapter object, LoadedObjects loaded, String line) {
        int pos = line.indexOf(58);
        if (pos == -1) {
            throw new FixtureException("no colon (:) in: " + line.trim());
        }
        String name = line.substring(0, pos).trim();
        String data = line.substring(pos + 1).trim();
        try {
            ObjectAssociation association = object.getSpecification().getAssociation(name);
            if (data.trim().length() == 0) {
                if (association instanceof OneToOneAssociation && !association.isEmpty(object, InteractionInitiatedBy.FRAMEWORK)) {
                    OneToOneAssociation property = (OneToOneAssociation)association;
                    property.set(object, null, InteractionInitiatedBy.FRAMEWORK);
                }
            } else if (association.isOneToManyAssociation()) {
                String[] ids = data.split(" ");
                ObjectAdapter[] elements = new ObjectAdapter[ids.length];
                for (int i = 0; i < ids.length; ++i) {
                    elements[i] = loaded.get(ids[i]);
                }
                ObjectAdapter collection = association.get(object, InteractionInitiatedBy.FRAMEWORK);
                CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec((ObjectAdapter)collection);
                facet.init(collection, elements);
            } else if (association.getSpecification().isParseable()) {
                data = data.replaceAll("\\n", "\n");
                ParseableFacet facet = (ParseableFacet)association.getSpecification().getFacet(ParseableFacet.class);
                ObjectAdapter value = facet.parseTextEntry(null, data, InteractionInitiatedBy.FRAMEWORK);
                ((OneToOneAssociation)association).initAssociation(object, value);
            } else if (association.isOneToOneAssociation()) {
                ObjectAdapter value = loaded.get(data);
                ((OneToOneAssociation)association).initAssociation(object, value);
            }
        }
        catch (ObjectSpecificationException e) {
            LOG.info("no field for '" + name + "', skipping entry: " + data);
        }
    }

    public void save(Set<Object> objects, Writer out) throws IOException {
        PrintWriter writer = new PrintWriter(out);
        SavedObjects saved = new SavedObjects();
        for (Object object : objects) {
            ObjectAdapter adapter = this.getPersistenceSession().adapterFor(object);
            this.saveData(writer, adapter, saved);
        }
        out.close();
    }

    private void saveData(PrintWriter writer, ObjectAdapter adapter, SavedObjects saved) {
        String id = saved.getId(adapter);
        writer.println(adapter.getSpecification().getFullIdentifier() + "#" + id);
        ObjectSpecification adapterSpec = adapter.getSpecification();
        List associations = adapterSpec.getAssociations(Contributed.EXCLUDED);
        for (ObjectAssociation association : associations) {
            CollectionFacet facet;
            if (association.isNotPersisted()) continue;
            ObjectAdapter associatedObject = association.get(adapter, InteractionInitiatedBy.FRAMEWORK);
            boolean isEmpty = association.isEmpty(adapter, InteractionInitiatedBy.FRAMEWORK);
            String associationId = association.getId();
            writer.write("  " + associationId + ": ");
            if (isEmpty) {
                writer.println();
                continue;
            }
            if (association.isOneToManyAssociation()) {
                facet = (CollectionFacet)associatedObject.getSpecification().getFacet(CollectionFacet.class);
                for (ObjectAdapter element : facet.iterable(associatedObject)) {
                    String refId = saved.getId(element);
                    String cls = element.getSpecification().getFullIdentifier();
                    writer.print(cls + "#" + refId + " ");
                }
                writer.println();
                continue;
            }
            if (association.getSpecification().isParseable()) {
                facet = (ParseableFacet)associatedObject.getSpecification().getFacet(ParseableFacet.class);
                String encodedValue = facet.parseableTitle(associatedObject);
                encodedValue = encodedValue.replaceAll("\n", "\\n");
                writer.println(encodedValue);
                continue;
            }
            if (!association.isOneToOneAssociation()) continue;
            String refId = saved.getId(associatedObject);
            String cls = associatedObject.getSpecification().getFullIdentifier();
            writer.println(cls + "#" + refId);
        }
    }

    protected PersistenceSession getPersistenceSession() {
        return this.isisSessionFactory.getCurrentSession().getPersistenceSession();
    }
}

