/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.fixtures;

import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import org.apache.isis.applib.fixtures.CompositeFixture;
import org.apache.isis.applib.fixtures.FixtureType;
import org.apache.isis.applib.fixtures.InstallableFixture;
import org.apache.isis.applib.fixtures.LogonFixture;
import org.apache.isis.applib.fixtures.switchuser.SwitchUserService;
import org.apache.isis.core.commons.lang.ObjectExtensions;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixturesInstallerDelegate {
    private static final Logger LOG = LoggerFactory.getLogger(FixturesInstallerDelegate.class);
    private final IsisSessionFactory isisSessionFactory;
    private final SwitchUserService switchUserService;
    protected final List<Object> fixtures = Lists.newArrayList();
    private LogonFixture logonFixture;

    public FixturesInstallerDelegate(IsisSessionFactory isisSessionFactory) {
        this.isisSessionFactory = isisSessionFactory;
        this.switchUserService = (SwitchUserService)isisSessionFactory.getServicesInjector().lookupService(SwitchUserService.class);
    }

    public void addFixture(Object fixture) {
        if (fixture instanceof List) {
            List fixtureList = ObjectExtensions.asListT((Object)fixture, Object.class);
            for (Object eachFixture : fixtureList) {
                this.addFixture(eachFixture);
            }
        } else {
            this.fixtures.add(fixture);
        }
    }

    protected List<Object> getFixtures() {
        return Collections.unmodifiableList(this.fixtures);
    }

    public final void installFixtures() {
        this.installFixtures(this.getFixtures());
    }

    private void installFixtures(List<Object> fixtures) {
        for (Object fixture : fixtures) {
            this.installFixtureInTransaction(fixture);
        }
    }

    private void installFixtureInTransaction(Object fixture) {
        this.getServicesInjector().injectServicesInto(fixture);
        this.installFixtures(this.getFixtures(fixture));
        try {
            LOG.info("installing fixture: " + fixture);
            this.getTransactionManager().startTransaction();
            this.installFixture(fixture);
            this.saveLogonFixtureIfRequired(fixture);
            this.getTransactionManager().endTransaction();
            LOG.info("fixture installed");
        }
        catch (RuntimeException e) {
            LOG.error("installing fixture " + fixture.getClass().getName() + " failed; aborting ", (Throwable)e);
            try {
                this.getTransactionManager().abortTransaction();
            }
            catch (Exception e2) {
                LOG.error("failure during abort", (Throwable)e2);
            }
            throw e;
        }
    }

    private List<Object> getFixtures(Object fixture) {
        if (fixture instanceof CompositeFixture) {
            CompositeFixture compositeFixture = (CompositeFixture)fixture;
            return compositeFixture.getFixtures();
        }
        return Collections.emptyList();
    }

    private void installFixture(Object fixture) {
        InstallableFixture installableFixture;
        this.isisSessionFactory.getServicesInjector().injectServicesInto(fixture);
        if (fixture instanceof InstallableFixture && this.shouldInstallFixture(installableFixture = (InstallableFixture)fixture)) {
            installableFixture.install();
        }
        if (fixture instanceof LogonFixture) {
            this.logonFixture = (LogonFixture)fixture;
        }
    }

    private boolean shouldInstallFixture(InstallableFixture installableFixture) {
        FixtureType fixtureType = installableFixture.getType();
        if (fixtureType == FixtureType.DOMAIN_OBJECTS) {
            return !this.isisSessionFactory.getCurrentSession().getPersistenceSession().isFixturesInstalled();
        }
        return true;
    }

    public LogonFixture getLogonFixture() {
        return this.logonFixture;
    }

    private void saveLogonFixtureIfRequired(Object fixture) {
        if (fixture instanceof LogonFixture) {
            if (this.logonFixture != null) {
                LOG.warn("Already specified logon fixture, using latest provided");
            }
            this.logonFixture = (LogonFixture)fixture;
        }
    }

    private ServicesInjector getServicesInjector() {
        return this.isisSessionFactory.getServicesInjector();
    }

    private PersistenceSession getPersistenceSession() {
        return this.isisSessionFactory.getCurrentSession().getPersistenceSession();
    }

    private IsisTransactionManager getTransactionManager() {
        return this.getPersistenceSession().getTransactionManager();
    }
}

