/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.fixtures;

import java.util.List;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.fixtures.LogonFixture;
import org.apache.isis.applib.fixtures.switchuser.SwitchUserService;
import org.apache.isis.applib.fixtures.switchuser.SwitchUserServiceAware;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.services.persistsession.PersistenceSessionServiceInternal;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authentication.AuthenticationRequest;
import org.apache.isis.core.runtime.fixtures.authentication.AuthenticationRequestLogonFixture;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;

@DomainService(nature=NatureOfService.DOMAIN)
public class SwitchUserServiceImpl
implements SwitchUserService {
    @Inject
    AuthenticationManager authenticationManager;
    @Inject
    IsisSessionFactory isisSessionFactory;
    @Inject
    PersistenceSessionServiceInternal persistenceSessionServiceInternal;

    @Programmatic
    public void switchUser(String username, List<String> roles) {
        this.switchUser(new LogonFixture(username, roles));
    }

    @Programmatic
    public void switchUser(String username, String ... roles) {
        this.switchUser(new LogonFixture(username, roles));
    }

    private void switchUser(LogonFixture logonFixture) {
        this.reopenSession((AuthenticationRequest)new AuthenticationRequestLogonFixture(logonFixture));
    }

    private void reopenSession(AuthenticationRequest authRequest) {
        this.persistenceSessionServiceInternal.commit();
        this.isisSessionFactory.closeSession();
        AuthenticationSession authenticationSession = this.authenticationManager.authenticate(authRequest);
        this.isisSessionFactory.openSession(authenticationSession);
        this.persistenceSessionServiceInternal.beginTran();
    }

    @Deprecated
    @Programmatic
    public void injectInto(Object fixture) {
        if (fixture instanceof SwitchUserServiceAware) {
            SwitchUserServiceAware serviceAware = (SwitchUserServiceAware)fixture;
            serviceAware.setService((SwitchUserService)this);
        }
    }
}

