/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence.query;

import java.util.List;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryBuiltInAbstract;

public class PersistenceQueryFindByPattern
extends PersistenceQueryBuiltInAbstract {
    private final ObjectAdapter pattern;

    public ObjectAdapter getPattern() {
        return this.pattern;
    }

    public PersistenceQueryFindByPattern(ObjectSpecification specification, ObjectAdapter pattern, SpecificationLoader specificationLoader, long ... range) {
        super(specification, specificationLoader, range);
        this.pattern = pattern;
    }

    @Override
    public boolean matches(ObjectAdapter object) {
        ObjectSpecification requiredSpec = this.pattern.getSpecification();
        ObjectSpecification objectSpec = object.getSpecification();
        return objectSpec.equals(requiredSpec) && this.matchesPattern(this.pattern, object);
    }

    private boolean matchesPattern(ObjectAdapter pattern, ObjectAdapter instance) {
        ObjectAdapter object = instance;
        ObjectSpecification nc = object.getSpecification();
        List fields = nc.getAssociations(Contributed.EXCLUDED);
        for (int f = 0; f < fields.size(); ++f) {
            ObjectAdapter reqd;
            ObjectAssociation fld = (ObjectAssociation)fields.get(f);
            if (fld.isNotPersisted() || !fld.isOneToOneAssociation() || fld.isEmpty(pattern, InteractionInitiatedBy.FRAMEWORK) || (reqd = fld.get(pattern, InteractionInitiatedBy.FRAMEWORK)) == null) continue;
            ObjectAdapter search = fld.get(object, InteractionInitiatedBy.FRAMEWORK);
            if (search == null) {
                return false;
            }
            if (fld.getSpecification().isValue()) {
                if (reqd.getObject().equals(search.getObject())) continue;
                return false;
            }
            String r = reqd.titleString(null).toLowerCase();
            String s = search.titleString(null).toLowerCase();
            if (s.indexOf(r) != -1) continue;
            return false;
        }
        return this.matchesRange(true);
    }
}

