/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence.query;

import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryBuiltInAbstract;

public class PersistenceQueryFindByTitle
extends PersistenceQueryBuiltInAbstract {
    private final String title;

    public PersistenceQueryFindByTitle(ObjectSpecification specification, String title, SpecificationLoader specificationLoader, long ... range) {
        super(specification, specificationLoader, range);
        this.title = title == null ? "" : title.toLowerCase();
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean matches(ObjectAdapter object) {
        String titleString = object.titleString().toLowerCase();
        return this.matchesRange(this.matches(titleString));
    }

    public boolean matches(String titleString) {
        String objectTitle = titleString.toLowerCase();
        return objectTitle.indexOf(this.title) >= 0;
    }

    public String toString() {
        ToString str = ToString.createAnonymous((Object)this);
        str.append("spec", this.getSpecification().getShortIdentifier());
        str.append("title", this.title);
        return str.toString();
    }
}

