/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.runner;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.session.IsisSessionFactoryBuilder;
import org.apache.isis.core.runtime.systemusinginstallers.IsisComponentProviderUsingInstallers;

public class IsisInjectModule
extends AbstractModule {
    private static final AppManifest APP_MANIFEST_NOOP = new AppManifest(){

        public List<Class<?>> getModules() {
            return null;
        }

        public List<Class<?>> getAdditionalServices() {
            return null;
        }

        public String getAuthenticationMechanism() {
            return null;
        }

        public String getAuthorizationMechanism() {
            return null;
        }

        public List<Class<? extends FixtureScript>> getFixtures() {
            return null;
        }

        public Map<String, String> getConfigurationProperties() {
            return null;
        }
    };
    private final DeploymentCategory deploymentCategory;
    private final IsisConfigurationDefault isisConfiguration;

    public IsisInjectModule(DeploymentCategory deploymentCategory, IsisConfigurationDefault isisConfiguration) {
        this.isisConfiguration = isisConfiguration;
        this.deploymentCategory = deploymentCategory;
    }

    protected void configure() {
        this.bind(AppManifest.class).toInstance((Object)APP_MANIFEST_NOOP);
    }

    @Provides
    @Singleton
    protected IsisConfiguration provideConfiguration() {
        return this.isisConfiguration;
    }

    @Provides
    @Singleton
    protected DeploymentCategory provideDeploymentCategory() {
        return this.deploymentCategory;
    }

    @Provides
    @Inject
    @Singleton
    protected IsisSessionFactory provideIsisSessionFactory(AppManifest appManifestIfAny) {
        AppManifest appManifest = appManifestIfAny != APP_MANIFEST_NOOP ? appManifestIfAny : null;
        IsisComponentProviderUsingInstallers componentProvider = new IsisComponentProviderUsingInstallers(appManifest, (IsisConfiguration)this.isisConfiguration);
        IsisSessionFactoryBuilder builder = new IsisSessionFactoryBuilder(componentProvider, this.deploymentCategory);
        return builder.buildSessionFactory();
    }

    @Provides
    @Inject
    @Singleton
    protected ServicesInjector provideServicesInjector(IsisSessionFactory isisSessionFactory) {
        return isisSessionFactory.getServicesInjector();
    }
}

