/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.runner.opts;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.isis.core.commons.configbuilder.IsisConfigurationBuilder;
import org.apache.isis.core.runtime.optionhandler.BootPrinter;
import org.apache.isis.core.runtime.optionhandler.OptionHandlerAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptionHandlerSystemProperties
extends OptionHandlerAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(OptionHandlerSystemProperties.class);
    private Map<String, String> additionalProperties;

    public void addOption(Options options) {
    }

    public boolean handle(CommandLine commandLine, BootPrinter bootPrinter, Options options) {
        this.additionalProperties = OptionHandlerSystemProperties.asMap(System.getProperties());
        return true;
    }

    private static Map<String, String> asMap(Properties properties) {
        TreeMap map = Maps.newTreeMap();
        for (String key : properties.stringPropertyNames()) {
            String value = properties.getProperty(key);
            if (!key.startsWith("isis.")) continue;
            map.put(key, value);
        }
        return map;
    }

    public void prime(IsisConfigurationBuilder isisConfigurationBuilder) {
        LOG.debug("priming configuration builder: " + this.additionalProperties.size() + " properties to prime");
        OptionHandlerSystemProperties.addConfigurationProperties(isisConfigurationBuilder, this.additionalProperties);
    }

    private static void addConfigurationProperties(IsisConfigurationBuilder isisConfigurationBuilder, Map<String, String> additionalProperties) {
        for (String propertyKey : additionalProperties.keySet()) {
            String propertyValue = additionalProperties.get(propertyKey);
            LOG.info("priming: " + propertyKey + "=" + propertyValue);
            isisConfigurationBuilder.add(propertyKey, propertyValue);
        }
    }
}

