/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.isis.core.runtime.services.Parsed;

class DeweyOrderUtil {
    public static final <V> Function<Parsed, Map.Entry<String, V>> toMapEntry() {
        return new Function<Parsed, Map.Entry<String, V>>(){

            public Map.Entry<String, V> apply(Parsed input) {
                return input.toMapEntry();
            }
        };
    }

    private DeweyOrderUtil() {
    }

    static <V> List<Map.Entry<String, V>> deweySorted(Map<String, V> map) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (Map.Entry<String, V> entry : map.entrySet()) {
            set.add(entry);
        }
        return DeweyOrderUtil.deweySorted(set);
    }

    static <V> List<Map.Entry<String, V>> deweySorted(Set<Map.Entry<String, V>> keys) {
        if (keys == null) {
            throw new IllegalArgumentException("Keys cannot be null");
        }
        Iterable parsedIter = Iterables.transform(keys, (Function)new Function<Map.Entry<String, V>, Parsed<V>>(){

            public Parsed<V> apply(Map.Entry<String, V> input) {
                return new Parsed(input);
            }
        });
        TreeSet parseds = Sets.newTreeSet((Iterable)parsedIter);
        Iterable transform = Iterables.transform((Iterable)parseds, DeweyOrderUtil.toMapEntry());
        return Lists.newArrayList((Iterable)transform);
    }
}

