/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import javassist.util.proxy.MethodFilter;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.RequestScoped;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.factory.InstanceCreationClassException;
import org.apache.isis.core.commons.factory.InstanceCreationException;
import org.apache.isis.core.commons.lang.ArrayExtensions;
import org.apache.isis.core.commons.lang.MethodExtensions;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.JavassistEnhanced;
import org.apache.isis.core.runtime.services.InitialisationException;
import org.apache.isis.core.runtime.services.RequestScopedService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceInstantiator {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceInstantiator.class);
    private Map<String, String> props;
    private Set<Class<?>> cached = Sets.newHashSet();
    private Map<Class<?>, Method> postConstructMethodsByServiceClass = Maps.newConcurrentMap();
    private Map<Class<?>, Method> preDestroyMethodsByServiceClass = Maps.newConcurrentMap();

    public void setConfiguration(IsisConfiguration configuration) {
        this.props = configuration.asMap();
    }

    private void ensureInitialized() {
        if (this.props == null) {
            throw new IllegalStateException("IsisConfiguration properties not set on ServiceInstantiator prior to first-use");
        }
    }

    public Object createInstance(String type) {
        Class<?> cls = this.loadClass(type);
        if (cls == null || cls.isAnonymousClass()) {
            return null;
        }
        return this.createInstance(cls);
    }

    private Class<?> loadClass(String className) {
        try {
            LOG.debug("loading class for service: " + className);
            return Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new InitialisationException(String.format("Cannot find class '%s' for service", className));
        }
    }

    public <T> T createInstance(Class<T> cls) {
        this.ensureInitialized();
        if (cls.isAnnotationPresent(RequestScoped.class)) {
            return this.instantiateRequestScopedProxy(cls);
        }
        return ServiceInstantiator.instantiateSingleton(cls);
    }

    private static <T> T instantiateSingleton(Class<T> cls) {
        return ServiceInstantiator.instantiate(cls);
    }

    private <T> T instantiateRequestScopedProxy(final Class<T> cls) {
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setSuperclass(cls);
        proxyFactory.setInterfaces((Class[])ArrayExtensions.combine((Object[][])new Class[][]{cls.getInterfaces(), {RequestScopedService.class, JavassistEnhanced.class}}));
        proxyFactory.setFilter(new MethodFilter(){

            public boolean isHandled(Method m) {
                return !m.getName().equals("finalize");
            }
        });
        Class proxySubclass = proxyFactory.createClass();
        try {
            Object newInstance = proxySubclass.newInstance();
            ProxyObject proxyObject = (ProxyObject)newInstance;
            proxyObject.setHandler(new MethodHandler(){
                private ThreadLocal<T> serviceByThread = new ThreadLocal();

                public Object invoke(Object proxied, Method proxyMethod, Method proxiedMethod, Object[] args) throws Throwable {
                    ServiceInstantiator.this.cacheMethodsIfNecessary(cls);
                    if (proxyMethod.getName().equals("__isis_startRequest")) {
                        Object service = ServiceInstantiator.instantiate(cls);
                        this.serviceByThread.set(service);
                        ServicesInjector servicesInjector = (ServicesInjector)args[0];
                        servicesInjector.injectServicesInto(service);
                        return null;
                    }
                    if (proxyMethod.getName().equals("__isis_postConstruct")) {
                        Object service = this.serviceByThread.get();
                        ServiceInstantiator.this.callPostConstructIfPresent(service);
                        return null;
                    }
                    if (proxyMethod.getName().equals("__isis_preDestroy")) {
                        Object service = this.serviceByThread.get();
                        ServiceInstantiator.this.callPreDestroyIfPresent(service);
                        return null;
                    }
                    if (proxyMethod.getName().equals("__isis_endRequest")) {
                        this.serviceByThread.set(null);
                        return null;
                    }
                    if (proxyMethod.getName().equals("hashCode") && proxyMethod.getParameterTypes().length == 0) {
                        Object service = this.serviceByThread.get();
                        return service != null ? service.hashCode() : this.hashCode();
                    }
                    if (proxyMethod.getName().equals("equals") && proxyMethod.getParameterTypes().length == 1 && proxyMethod.getParameterTypes()[0] == Object.class) {
                        Object service = this.serviceByThread.get();
                        return service != null ? service.equals(args[0]) : this.equals(args[0]);
                    }
                    if (proxyMethod.getName().equals("toString") && proxyMethod.getParameterTypes().length == 0) {
                        Object service = this.serviceByThread.get();
                        return service != null ? service.toString() : this.toString();
                    }
                    Object service = this.serviceByThread.get();
                    if (service == null) {
                        throw new IllegalStateException("No service of type " + cls + " is available on this ");
                    }
                    Object proxiedReturn = proxyMethod.invoke(service, args);
                    return proxiedReturn;
                }
            });
            return newInstance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IsisException((Throwable)e);
        }
    }

    <T> void callPostConstructIfPresent(T service) {
        Class<?> serviceClass = service.getClass();
        Method postConstructMethod = this.postConstructMethodsByServiceClass.get(serviceClass);
        if (postConstructMethod == null) {
            return;
        }
        int numParams = postConstructMethod.getParameterTypes().length;
        if (LOG.isDebugEnabled()) {
            LOG.debug("... calling @PostConstruct method: " + serviceClass.getName() + ": " + postConstructMethod.getName());
        }
        if (numParams == 0) {
            MethodExtensions.invoke((Method)postConstructMethod, service);
        } else {
            MethodExtensions.invoke((Method)postConstructMethod, service, (Object[])new Object[]{this.props});
        }
    }

    <T> void callPreDestroyIfPresent(T service) throws InvocationTargetException, IllegalAccessException {
        Class<?> serviceClass = service.getClass();
        Method preDestroyMethod = this.preDestroyMethodsByServiceClass.get(serviceClass);
        if (preDestroyMethod == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("... calling @PreDestroy method: " + serviceClass.getName() + ": " + preDestroyMethod.getName());
        }
        try {
            MethodExtensions.invoke((Method)preDestroyMethod, service);
        }
        catch (Exception ex) {
            LOG.warn("... @PreDestroy method threw exception - continuing anyway", (Throwable)ex);
        }
    }

    private void cacheMethodsIfNecessary(Class<?> serviceClass) {
        if (this.cached.contains(serviceClass)) {
            return;
        }
        this.cacheMethods(serviceClass);
        this.cached.add(serviceClass);
    }

    private void cacheMethods(Class<?> serviceClass) {
        Method[] methods = serviceClass.getMethods();
        Method postConstructMethod = null;
        for (Method method : methods) {
            PostConstruct postConstructAnnotation = method.getAnnotation(PostConstruct.class);
            if (postConstructAnnotation == null) continue;
            if (postConstructMethod != null) {
                throw new RuntimeException("Found more than one @PostConstruct method; service is: " + serviceClass.getName() + ", found " + postConstructMethod.getName() + " and " + method.getName());
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            switch (parameterTypes.length) {
                case 0: {
                    break;
                }
                case 1: {
                    if (Map.class == parameterTypes[0]) break;
                    throw new RuntimeException("@PostConstruct method must be no-arg or 1-arg accepting java.util.Map; method is: " + serviceClass.getName() + "#" + method.getName());
                }
                default: {
                    throw new RuntimeException("@PostConstruct method must be no-arg or 1-arg accepting java.util.Map; method is: " + serviceClass.getName() + "#" + method.getName());
                }
            }
            postConstructMethod = method;
        }
        Method preDestroyMethod = null;
        for (Method method : methods) {
            PreDestroy preDestroyAnnotation = method.getAnnotation(PreDestroy.class);
            if (preDestroyAnnotation == null) continue;
            if (preDestroyMethod != null) {
                throw new RuntimeException("Found more than one @PreDestroy method; service is: " + serviceClass.getName() + ", found " + preDestroyMethod.getName() + " and " + method.getName());
            }
            Class<?>[] parameterTypes = method.getParameterTypes();
            switch (parameterTypes.length) {
                case 0: {
                    break;
                }
                default: {
                    throw new RuntimeException("@PreDestroy method must be no-arg; method is: " + serviceClass.getName() + "#" + method.getName());
                }
            }
            preDestroyMethod = method;
        }
        if (postConstructMethod != null) {
            this.postConstructMethodsByServiceClass.put(serviceClass, postConstructMethod);
        }
        if (preDestroyMethod != null) {
            this.preDestroyMethodsByServiceClass.put(serviceClass, preDestroyMethod);
        }
    }

    private static <T> T instantiate(Class<T> cls) {
        try {
            return cls.newInstance();
        }
        catch (NoClassDefFoundError e) {
            throw new InstanceCreationClassException("Class found '" + cls + "', but is missing a dependent class", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new InstanceCreationException("Could not instantiate an object of class '" + cls.getName() + "'; " + e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new InstanceCreationException("Could not access the class '" + cls.getName() + "'; " + e.getMessage(), (Throwable)e);
        }
    }
}

