/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.authsess;

import java.util.List;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.AuthenticationSessionProvider;
import org.apache.isis.core.metamodel.services.user.UserServiceDefault;
import org.apache.isis.core.runtime.authentication.standard.SimpleSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;

@DomainService(nature=NatureOfService.DOMAIN)
public class AuthenticationSessionProviderDefault
implements AuthenticationSessionProvider {
    @Inject
    UserServiceDefault userServiceDefault;
    @Inject
    IsisSessionFactory isisSessionFactory;

    @Programmatic
    public AuthenticationSession getAuthenticationSession() {
        UserServiceDefault.UserAndRoleOverrides userAndRoleOverrides = this.userServiceDefault.currentOverridesIfAny();
        if (userAndRoleOverrides != null) {
            String user = userAndRoleOverrides.getUser();
            List roles = userAndRoleOverrides.getRoles();
            return new SimpleSession(user, roles);
        }
        return this.isisSessionFactory.getCurrentSession().getAuthenticationSession();
    }
}

