/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.background;

import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import org.apache.isis.applib.services.background.ActionInvocationMemento;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService2;
import org.apache.isis.applib.services.clock.ClockService;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.iactn.Interaction;
import org.apache.isis.applib.services.iactn.InteractionContext;
import org.apache.isis.applib.services.jaxb.JaxbService;
import org.apache.isis.applib.services.memento.MementoService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.CommandUtil;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.runtime.services.memento.MementoServiceDefault;
import org.apache.isis.core.runtime.sessiontemplate.AbstractIsisSessionTemplate;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.system.transaction.TransactionalClosure;
import org.apache.isis.schema.cmd.v1.ActionDto;
import org.apache.isis.schema.cmd.v1.CommandDto;
import org.apache.isis.schema.cmd.v1.MemberDto;
import org.apache.isis.schema.cmd.v1.ParamDto;
import org.apache.isis.schema.cmd.v1.ParamsDto;
import org.apache.isis.schema.cmd.v1.PropertyDto;
import org.apache.isis.schema.common.v1.InteractionType;
import org.apache.isis.schema.common.v1.OidDto;
import org.apache.isis.schema.common.v1.OidsDto;
import org.apache.isis.schema.common.v1.ValueWithTypeDto;
import org.apache.isis.schema.utils.CommandDtoUtils;
import org.apache.isis.schema.utils.CommonDtoUtils;

public abstract class BackgroundCommandExecution
extends AbstractIsisSessionTemplate {
    private final MementoServiceDefault mementoService = new MementoServiceDefault().withNoEncoding();
    @Inject
    private BookmarkService2 bookmarkService;
    @Inject
    private JaxbService jaxbService;
    @Inject
    private CommandContext commandContext;
    @Inject
    private InteractionContext interactionContext;
    @Inject
    private ClockService clockService;

    @Override
    protected void doExecute(Object context) {
        PersistenceSession persistenceSession = this.getPersistenceSession();
        IsisTransactionManager transactionManager = this.getTransactionManager(persistenceSession);
        final ArrayList backgroundCommands = Lists.newArrayList();
        transactionManager.executeWithinTransaction(new TransactionalClosure(){

            public void execute() {
                backgroundCommands.addAll(BackgroundCommandExecution.this.findBackgroundCommandsToExecute());
            }
        });
        for (Command backgroundCommand : backgroundCommands) {
            this.execute(transactionManager, backgroundCommand);
        }
    }

    protected abstract List<? extends Command> findBackgroundCommandsToExecute();

    private void execute(final IsisTransactionManager transactionManager, final Command backgroundCommand) {
        transactionManager.executeWithinTransaction(backgroundCommand, new TransactionalClosure(){

            public void execute() {
                Interaction backgroundInteraction = BackgroundCommandExecution.this.interactionContext.getInteraction();
                String memento = backgroundCommand.getMemento();
                try {
                    backgroundCommand.setExecutor(Command.Executor.BACKGROUND);
                    boolean legacy = memento.startsWith("<memento");
                    if (legacy) {
                        ActionInvocationMemento aim = new ActionInvocationMemento((MementoService)BackgroundCommandExecution.this.mementoService, memento);
                        String actionId = aim.getActionId();
                        Bookmark targetBookmark = aim.getTarget();
                        Object targetObject = BackgroundCommandExecution.this.bookmarkService.lookup(targetBookmark, BookmarkService2.FieldResetPolicy.RESET);
                        ObjectAdapter targetAdapter = BackgroundCommandExecution.this.adapterFor(targetObject);
                        ObjectSpecification specification = targetAdapter.getSpecification();
                        ObjectAction objectAction = BackgroundCommandExecution.findActionElseNull(specification, actionId);
                        if (objectAction == null) {
                            throw new RuntimeException(String.format("Unknown action '%s'", actionId));
                        }
                        ObjectAdapter mixedInAdapter = null;
                        ObjectAdapter[] argAdapters = BackgroundCommandExecution.this.argAdaptersFor(aim);
                        ObjectAdapter resultAdapter = objectAction.execute(targetAdapter, mixedInAdapter, argAdapters, InteractionInitiatedBy.FRAMEWORK);
                        if (resultAdapter != null) {
                            Bookmark resultBookmark = CommandUtil.bookmarkFor((ObjectAdapter)resultAdapter);
                            backgroundCommand.setResult(resultBookmark);
                            backgroundInteraction.getCurrentExecution().setReturned(resultAdapter.getObject());
                        }
                    } else {
                        CommandDto dto = (CommandDto)BackgroundCommandExecution.this.jaxbService.fromXml(CommandDto.class, memento);
                        MemberDto memberDto = dto.getMember();
                        String memberId = memberDto.getMemberIdentifier();
                        OidsDto oidsDto = CommandDtoUtils.targetsFor((CommandDto)dto);
                        List targetOidDtos = oidsDto.getOid();
                        InteractionType interactionType = memberDto.getInteractionType();
                        if (interactionType == InteractionType.ACTION_INVOCATION) {
                            ActionDto actionDto = (ActionDto)memberDto;
                            for (OidDto targetOidDto : targetOidDtos) {
                                ObjectAdapter[] argAdapters;
                                ObjectAdapter targetAdapter = BackgroundCommandExecution.this.targetAdapterFor(targetOidDto);
                                ObjectAction objectAction = this.findObjectAction(targetAdapter, memberId);
                                ObjectAdapter resultAdapter = objectAction.execute(targetAdapter, null, argAdapters = BackgroundCommandExecution.this.argAdaptersFor(actionDto), InteractionInitiatedBy.FRAMEWORK);
                                if (resultAdapter == null) continue;
                                Bookmark resultBookmark = CommandUtil.bookmarkFor((ObjectAdapter)resultAdapter);
                                backgroundCommand.setResult(resultBookmark);
                            }
                        } else {
                            PropertyDto propertyDto = (PropertyDto)memberDto;
                            for (OidDto targetOidDto : targetOidDtos) {
                                Bookmark bookmark = Bookmark.from((OidDto)targetOidDto);
                                Object targetObject = BackgroundCommandExecution.this.bookmarkService.lookup(bookmark);
                                ObjectAdapter targetAdapter = BackgroundCommandExecution.this.adapterFor(targetObject);
                                OneToOneAssociation property = this.findOneToOneAssociation(targetAdapter, memberId);
                                ObjectAdapter newValueAdapter = BackgroundCommandExecution.this.newValueAdapterFor(propertyDto);
                                property.set(targetAdapter, newValueAdapter, InteractionInitiatedBy.FRAMEWORK);
                            }
                        }
                    }
                }
                catch (RuntimeException e) {
                    backgroundCommand.setException(Throwables.getStackTraceAsString((Throwable)e));
                    transactionManager.getCurrentTransaction().clearAbortCauseAndContinue();
                }
                Interaction.Execution priorExecution = backgroundInteraction.getPriorExecution();
                Timestamp completedAt = priorExecution != null ? priorExecution.getCompletedAt() : BackgroundCommandExecution.this.clockService.nowAsJavaSqlTimestamp();
                backgroundCommand.setCompletedAt(completedAt);
            }

            private ObjectAction findObjectAction(ObjectAdapter targetAdapter, String actionId) throws RuntimeException {
                ObjectSpecification specification = targetAdapter.getSpecification();
                ObjectAction objectAction = BackgroundCommandExecution.findActionElseNull(specification, actionId);
                if (objectAction == null) {
                    throw new RuntimeException(String.format("Unknown action '%s'", actionId));
                }
                return objectAction;
            }

            private OneToOneAssociation findOneToOneAssociation(ObjectAdapter targetAdapter, String propertyId) throws RuntimeException {
                ObjectSpecification specification = targetAdapter.getSpecification();
                OneToOneAssociation property = BackgroundCommandExecution.findOneToOneAssociationElseNull(specification, propertyId);
                if (property == null) {
                    throw new RuntimeException(String.format("Unknown property '%s'", propertyId));
                }
                return property;
            }
        });
    }

    protected ObjectAdapter newValueAdapterFor(PropertyDto propertyDto) {
        ValueWithTypeDto newValue = propertyDto.getNewValue();
        Object arg = CommonDtoUtils.getValue((ValueWithTypeDto)newValue);
        return this.adapterFor(arg);
    }

    private static ObjectAction findActionElseNull(ObjectSpecification specification, String actionId) {
        List objectActions = specification.getObjectActions(Contributed.INCLUDED);
        for (ObjectAction objectAction : objectActions) {
            if (!objectAction.getIdentifier().toClassAndNameIdentityString().equals(actionId)) continue;
            return objectAction;
        }
        return null;
    }

    private static OneToOneAssociation findOneToOneAssociationElseNull(ObjectSpecification specification, String propertyId) {
        List associations = specification.getAssociations(Contributed.INCLUDED);
        for (ObjectAssociation association : associations) {
            if (!association.getIdentifier().toClassAndNameIdentityString().equals(propertyId) || !(association instanceof OneToOneAssociation)) continue;
            return (OneToOneAssociation)association;
        }
        return null;
    }

    private ObjectAdapter[] argAdaptersFor(ActionInvocationMemento aim) {
        int numArgs = aim.getNumArgs();
        ArrayList argumentAdapters = Lists.newArrayList();
        for (int i = 0; i < numArgs; ++i) {
            ObjectAdapter argAdapter = this.argAdapterFor(aim, i);
            argumentAdapters.add(argAdapter);
        }
        return argumentAdapters.toArray(new ObjectAdapter[0]);
    }

    private ObjectAdapter argAdapterFor(ActionInvocationMemento aim, int num) {
        try {
            Class argType = aim.getArgType(num);
            Object arg = aim.getArg(num, argType);
            if (arg == null) {
                return null;
            }
            return this.argAdapterFor(argType, arg);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected ObjectAdapter targetAdapterFor(OidDto targetOidDto) {
        return this.adapterFor(targetOidDto);
    }

    protected ObjectAdapter argAdapterFor(Class<?> argType, Object arg) {
        return this.adapterFor(arg);
    }

    private ObjectAdapter[] argAdaptersFor(ActionDto actionDto) {
        List<ParamDto> params = BackgroundCommandExecution.paramDtosFrom(actionDto);
        ArrayList args = Lists.newArrayList((Iterable)Iterables.transform(params, (Function)new Function<ParamDto, ObjectAdapter>(){

            public ObjectAdapter apply(ParamDto paramDto) {
                Object arg = CommonDtoUtils.getValue((ParamDto)paramDto);
                return BackgroundCommandExecution.this.adapterFor(arg);
            }
        }));
        return args.toArray(new ObjectAdapter[0]);
    }

    private static List<ParamDto> paramDtosFrom(ActionDto actionDto) {
        List parameterList;
        ParamsDto parameters = actionDto.getParameters();
        if (parameters != null && (parameterList = parameters.getParameter()) != null) {
            return parameterList;
        }
        return Collections.emptyList();
    }
}

