/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.changes;

import com.google.common.base.Function;
import java.util.Map;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.runtime.services.changes.PreAndPostValues;

public class AdapterAndProperty {
    private final ObjectAdapter objectAdapter;
    private final ObjectAssociation property;
    private final Bookmark bookmark;
    private final String propertyId;
    private final String bookmarkStr;

    public static AdapterAndProperty of(ObjectAdapter adapter, ObjectAssociation property) {
        return new AdapterAndProperty(adapter, property);
    }

    private AdapterAndProperty(ObjectAdapter adapter, ObjectAssociation property) {
        this.objectAdapter = adapter;
        this.property = property;
        RootOid oid = (RootOid)adapter.getOid();
        String objectType = oid.getObjectSpecId().asString();
        String identifier = oid.getIdentifier();
        this.bookmark = new Bookmark(objectType, identifier);
        this.bookmarkStr = this.bookmark.toString();
        this.propertyId = property.getId();
    }

    public ObjectAdapter getAdapter() {
        return this.objectAdapter;
    }

    public ObjectAssociation getProperty() {
        return this.property;
    }

    public Bookmark getBookmark() {
        return this.bookmark;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public String getMemberId() {
        return this.property.getIdentifier().toClassAndNameIdentityString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdapterAndProperty that = (AdapterAndProperty)o;
        if (this.bookmarkStr != null ? !this.bookmarkStr.equals(that.bookmarkStr) : that.bookmarkStr != null) {
            return false;
        }
        return !(this.propertyId != null ? !this.propertyId.equals(that.propertyId) : that.propertyId != null);
    }

    public int hashCode() {
        int result = this.propertyId != null ? this.propertyId.hashCode() : 0;
        result = 31 * result + (this.bookmarkStr != null ? this.bookmarkStr.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.bookmarkStr + " , " + this.getProperty().getId();
    }

    public Object getPropertyValue() {
        ObjectAdapter referencedAdapter = this.property.get(this.objectAdapter, InteractionInitiatedBy.FRAMEWORK);
        return referencedAdapter == null ? null : referencedAdapter.getObject();
    }

    static class Functions {
        static final Function<Map.Entry<AdapterAndProperty, PreAndPostValues>, ObjectAdapter> GET_ADAPTER = new Function<Map.Entry<AdapterAndProperty, PreAndPostValues>, ObjectAdapter>(){

            public ObjectAdapter apply(Map.Entry<AdapterAndProperty, PreAndPostValues> input) {
                AdapterAndProperty aap = input.getKey();
                return aap.getAdapter();
            }
        };

        private Functions() {
        }
    }
}

