/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.changes;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.PublishedObject;
import org.apache.isis.applib.services.HasTransactionId;
import org.apache.isis.applib.services.WithTransactionScope;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.runtime.services.changes.AdapterAndProperty;
import org.apache.isis.core.runtime.services.changes.PreAndPostValues;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;

@DomainService(nature=NatureOfService.DOMAIN)
@RequestScoped
public class ChangedObjectsServiceInternal
implements WithTransactionScope {
    private final Map<AdapterAndProperty, PreAndPostValues> enlistedObjectProperties = Maps.newLinkedHashMap();
    private Set<Map.Entry<AdapterAndProperty, PreAndPostValues>> changedObjectProperties;
    private final Map<ObjectAdapter, PublishedObject.ChangeKind> changeKindByEnlistedAdapter = Maps.newLinkedHashMap();

    @Programmatic
    public boolean isEnlisted(ObjectAdapter adapter) {
        return this.changeKindByEnlistedAdapter.containsKey(adapter);
    }

    @Programmatic
    public void enlistCreated(ObjectAdapter adapter) {
        if (this.shouldIgnore(adapter)) {
            return;
        }
        this.enlistForPublishing(adapter, PublishedObject.ChangeKind.CREATE);
        for (ObjectAssociation property : adapter.getSpecification().getAssociations(Contributed.EXCLUDED, ObjectAssociation.Filters.PROPERTIES)) {
            AdapterAndProperty aap = AdapterAndProperty.of(adapter, property);
            if (property.isNotPersisted()) continue;
            if (this.enlistedObjectProperties.containsKey(aap)) {
                return;
            }
            PreAndPostValues papv = PreAndPostValues.pre(IsisTransaction.Placeholder.NEW);
            this.enlistedObjectProperties.put(aap, papv);
        }
    }

    @Programmatic
    public void enlistUpdating(ObjectAdapter adapter) {
        if (this.shouldIgnore(adapter)) {
            return;
        }
        this.enlistForPublishing(adapter, PublishedObject.ChangeKind.UPDATE);
        for (ObjectAssociation property : adapter.getSpecification().getAssociations(Contributed.EXCLUDED, ObjectAssociation.Filters.PROPERTIES)) {
            AdapterAndProperty aap = AdapterAndProperty.of(adapter, property);
            if (property.isNotPersisted() || this.enlistedObjectProperties.containsKey(aap)) continue;
            PreAndPostValues papv = PreAndPostValues.pre(aap.getPropertyValue());
            this.enlistedObjectProperties.put(aap, papv);
        }
    }

    @Programmatic
    public void enlistDeleting(ObjectAdapter adapter) {
        if (this.shouldIgnore(adapter)) {
            return;
        }
        boolean enlisted = this.enlistForPublishing(adapter, PublishedObject.ChangeKind.DELETE);
        if (!enlisted) {
            return;
        }
        for (ObjectAssociation property : adapter.getSpecification().getAssociations(Contributed.EXCLUDED, ObjectAssociation.Filters.PROPERTIES)) {
            AdapterAndProperty aap = AdapterAndProperty.of(adapter, property);
            if (property.isNotPersisted()) continue;
            if (this.enlistedObjectProperties.containsKey(aap)) {
                return;
            }
            PreAndPostValues papv = PreAndPostValues.pre(aap.getPropertyValue());
            this.enlistedObjectProperties.put(aap, papv);
        }
    }

    private boolean enlistForPublishing(ObjectAdapter adapter, PublishedObject.ChangeKind current) {
        PublishedObject.ChangeKind previous = this.changeKindByEnlistedAdapter.get(adapter);
        if (previous == null) {
            this.changeKindByEnlistedAdapter.put(adapter, current);
            return true;
        }
        switch (previous) {
            case CREATE: {
                switch (current) {
                    case DELETE: {
                        this.changeKindByEnlistedAdapter.remove(adapter);
                    }
                    case CREATE: 
                    case UPDATE: {
                        return false;
                    }
                }
                break;
            }
            case UPDATE: {
                switch (current) {
                    case DELETE: {
                        this.changeKindByEnlistedAdapter.put(adapter, current);
                        return true;
                    }
                    case CREATE: 
                    case UPDATE: {
                        return false;
                    }
                }
                break;
            }
            case DELETE: {
                return false;
            }
        }
        return previous == null;
    }

    @Programmatic
    public Set<Map.Entry<AdapterAndProperty, PreAndPostValues>> getChangedObjectProperties() {
        return this.changedObjectProperties != null ? this.changedObjectProperties : (this.changedObjectProperties = this.capturePostValuesAndDrain(this.enlistedObjectProperties));
    }

    private Set<Map.Entry<AdapterAndProperty, PreAndPostValues>> capturePostValuesAndDrain(Map<AdapterAndProperty, PreAndPostValues> changedObjectProperties) {
        LinkedHashMap processedObjectProperties1 = Maps.newLinkedHashMap();
        while (!changedObjectProperties.isEmpty()) {
            LinkedHashSet keys = Sets.newLinkedHashSet(changedObjectProperties.keySet());
            for (AdapterAndProperty aap : keys) {
                PreAndPostValues papv = changedObjectProperties.remove(aap);
                ObjectAdapter adapter = aap.getAdapter();
                if (adapter.isDestroyed()) {
                    papv.setPost(IsisTransaction.Placeholder.DELETED);
                } else {
                    papv.setPost(aap.getPropertyValue());
                }
                processedObjectProperties1.put(aap, papv);
            }
        }
        return Collections.unmodifiableSet(Sets.filter(processedObjectProperties1.entrySet(), PreAndPostValues.Predicates.CHANGED));
    }

    protected boolean shouldIgnore(ObjectAdapter adapter) {
        ObjectSpecification adapterSpec = adapter.getSpecification();
        Class adapterClass = adapterSpec.getCorrespondingClass();
        return HasTransactionId.class.isAssignableFrom(adapterClass);
    }

    @Programmatic
    public Map<ObjectAdapter, PublishedObject.ChangeKind> getChangeKindByEnlistedAdapter() {
        return this.changeKindByEnlistedAdapter;
    }

    @Programmatic
    public int numberObjectsDirtied() {
        return this.changeKindByEnlistedAdapter.size();
    }

    @Programmatic
    public int numberObjectPropertiesModified() {
        if (this.changedObjectProperties == null) {
            this.getChangedObjectProperties();
        }
        return this.changedObjectProperties.size();
    }

    @Programmatic
    public void resetForNextTransaction() {
        this.enlistedObjectProperties.clear();
        this.changedObjectProperties = null;
    }

    static String asString(Object object) {
        return object != null ? object.toString() : null;
    }
}

