/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.email;

import com.google.common.base.Strings;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Properties;
import javax.activation.DataSource;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.mail.Authenticator;
import org.apache.commons.mail.DataSourceResolver;
import org.apache.commons.mail.DefaultAuthenticator;
import org.apache.commons.mail.EmailException;
import org.apache.commons.mail.ImageHtmlEmail;
import org.apache.commons.mail.resolver.DataSourceClassPathResolver;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.email.EmailService;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@DomainService(nature=NatureOfService.DOMAIN)
public class EmailServiceDefault
implements EmailService {
    private static final Logger LOG = LoggerFactory.getLogger(EmailServiceDefault.class);
    private static final String ISIS_SERVICE_EMAIL_SENDER_ADDRESS = "isis.service.email.sender.address";
    private static final String ISIS_SERVICE_EMAIL_SENDER_PASSWORD = "isis.service.email.sender.password";
    private static final String ISIS_SERVICE_EMAIL_SENDER_HOSTNAME = "isis.service.email.sender.hostname";
    private static final String ISIS_SERVICE_EMAIL_SENDER_HOSTNAME_DEFAULT = "smtp.gmail.com";
    private static final String ISIS_SERVICE_EMAIL_PORT = "isis.service.email.port";
    private static final int ISIS_SERVICE_EMAIL_PORT_DEFAULT = 587;
    private static final String ISIS_SERVICE_EMAIL_TLS_ENABLED = "isis.service.email.tls.enabled";
    private static final boolean ISIS_SERVICE_EMAIL_TLS_ENABLED_DEFAULT = true;
    private String senderEmailAddress;
    private String senderEmailPassword;
    private Integer senderEmailPort;
    private boolean initialized;
    @Inject
    IsisConfiguration configuration;

    @PostConstruct
    @Programmatic
    public void init() {
        if (this.initialized) {
            return;
        }
        this.senderEmailAddress = this.getSenderEmailAddress();
        this.senderEmailPassword = this.getSenderEmailPassword();
        this.senderEmailPort = this.getSenderEmailPort();
        this.initialized = true;
        if (!this.isConfigured()) {
            LOG.warn("NOT configured");
        } else {
            LOG.debug("configured");
        }
    }

    protected String getSenderEmailAddress() {
        return this.configuration.getString(ISIS_SERVICE_EMAIL_SENDER_ADDRESS);
    }

    protected String getSenderEmailPassword() {
        return this.configuration.getString(ISIS_SERVICE_EMAIL_SENDER_PASSWORD);
    }

    protected String getSenderEmailHostName() {
        return this.configuration.getString(ISIS_SERVICE_EMAIL_SENDER_HOSTNAME, ISIS_SERVICE_EMAIL_SENDER_HOSTNAME_DEFAULT);
    }

    protected Integer getSenderEmailPort() {
        return this.configuration.getInteger(ISIS_SERVICE_EMAIL_PORT, 587);
    }

    protected Boolean getSenderEmailTlsEnabled() {
        return this.configuration.getBoolean(ISIS_SERVICE_EMAIL_TLS_ENABLED, true);
    }

    public boolean isConfigured() {
        return !Strings.isNullOrEmpty((String)this.senderEmailAddress) && !Strings.isNullOrEmpty((String)this.senderEmailPassword);
    }

    public boolean send(List<String> toList, List<String> ccList, List<String> bccList, String subject, String body, DataSource ... attachments) {
        try {
            ImageHtmlEmail email = new ImageHtmlEmail();
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(this.senderEmailAddress, this.senderEmailPassword));
            email.setHostName(this.getSenderEmailHostName());
            email.setSmtpPort(this.senderEmailPort.intValue());
            email.setStartTLSEnabled(this.getSenderEmailTlsEnabled().booleanValue());
            email.setDataSourceResolver((DataSourceResolver)new DataSourceClassPathResolver("/", true));
            Properties properties = email.getMailSession().getProperties();
            properties.put("mail.smtps.auth", "true");
            properties.put("mail.debug", "true");
            properties.put("mail.smtps.port", "" + this.senderEmailPort);
            properties.put("mail.smtps.socketFactory.port", "" + this.senderEmailPort);
            properties.put("mail.smtps.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            properties.put("mail.smtps.socketFactory.fallback", "false");
            properties.put("mail.smtp.starttls.enable", "" + this.getSenderEmailTlsEnabled());
            email.setFrom(this.senderEmailAddress);
            email.setSubject(subject);
            email.setHtmlMsg(body);
            if (attachments != null && attachments.length > 0) {
                for (DataSource attachment : attachments) {
                    email.attach(attachment, attachment.getName(), "");
                }
            }
            if (this.notEmpty(toList)) {
                email.addTo(toList.toArray(new String[toList.size()]));
            }
            if (this.notEmpty(ccList)) {
                email.addCc(ccList.toArray(new String[ccList.size()]));
            }
            if (this.notEmpty(bccList)) {
                email.addBcc(bccList.toArray(new String[bccList.size()]));
            }
            email.send();
        }
        catch (EmailException ex) {
            LOG.error("An error occurred while trying to send an email about user email verification", (Throwable)ex);
            return false;
        }
        return true;
    }

    private boolean notEmpty(List<String> toList) {
        return toList != null && !toList.isEmpty();
    }
}

