/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.ixn;

import java.util.List;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;
import org.apache.isis.applib.services.iactn.Interaction;
import org.apache.isis.applib.services.iactn.InteractionContext;
import org.apache.isis.applib.services.user.UserService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.services.command.CommandDtoServiceInternal;
import org.apache.isis.core.metamodel.services.ixn.InteractionDtoServiceInternal;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.schema.cmd.v1.ActionDto;
import org.apache.isis.schema.cmd.v1.PropertyDto;
import org.apache.isis.schema.common.v1.ValueWithTypeDto;
import org.apache.isis.schema.ixn.v1.ActionInvocationDto;
import org.apache.isis.schema.ixn.v1.PropertyEditDto;
import org.apache.isis.schema.utils.CommandDtoUtils;
import org.apache.isis.schema.utils.InteractionDtoUtils;

@DomainService(nature=NatureOfService.DOMAIN)
public class InteractionDtoServiceInternalDefault
implements InteractionDtoServiceInternal {
    @Inject
    CommandDtoServiceInternal commandDtoServiceInternal;
    @Inject
    private BookmarkService bookmarkService;
    @Inject
    private InteractionContext interactionContext;
    @Inject
    private UserService userService;

    @Programmatic
    public ActionInvocationDto asActionInvocationDto(ObjectAction objectAction, ObjectAdapter targetAdapter, List<ObjectAdapter> argumentAdapters) {
        Interaction interaction = this.interactionContext.getInteraction();
        UUID transactionId = interaction.getTransactionId();
        int nextEventSequence = interaction.next(Interaction.Sequence.INTERACTION.id());
        Object targetPojo = targetAdapter.getObject();
        Bookmark targetBookmark = this.bookmarkService.bookmarkFor(targetPojo);
        String actionIdentifier = objectAction.getIdentifier().toClassAndNameIdentityString();
        String actionId = actionIdentifier.substring(actionIdentifier.indexOf(35) + 1);
        String targetTitle = targetBookmark.toString() + ": " + actionId;
        String currentUser = this.userService.getUser().getName();
        ActionDto actionDto = new ActionDto();
        this.commandDtoServiceInternal.addActionArgs(objectAction, actionDto, argumentAdapters.toArray(new ObjectAdapter[0]));
        List parameterDtos = CommandDtoUtils.parametersFor((ActionDto)actionDto).getParameter();
        String transactionIdStr = transactionId.toString();
        return InteractionDtoUtils.newActionInvocation((int)nextEventSequence, (Bookmark)targetBookmark, (String)targetTitle, (String)actionDto.getMemberIdentifier(), (List)parameterDtos, (String)currentUser);
    }

    @Programmatic
    public ActionInvocationDto updateResult(ActionInvocationDto actionInvocationDto, ObjectAction objectAction, Object resultPojo) {
        ObjectSpecification returnSpec = objectAction.getReturnType();
        Class returnType = returnSpec.getCorrespondingClass();
        InteractionDtoUtils.addReturn((ActionInvocationDto)actionInvocationDto, (Class)returnType, (Object)resultPojo, (BookmarkService)this.bookmarkService);
        return actionInvocationDto;
    }

    @Programmatic
    public PropertyEditDto asPropertyEditDto(OneToOneAssociation property, ObjectAdapter targetAdapter, ObjectAdapter newValueAdapterIfAny) {
        Interaction interaction = this.interactionContext.getInteraction();
        int nextEventSequence = interaction.next(Interaction.Sequence.INTERACTION.id());
        Object targetPojo = targetAdapter.getObject();
        Bookmark targetBookmark = this.bookmarkService.bookmarkFor(targetPojo);
        String propertyIdentifier = property.getIdentifier().toClassAndNameIdentityString();
        String propertyId = propertyIdentifier.substring(propertyIdentifier.indexOf(35) + 1);
        String targetTitle = targetBookmark.toString() + ": " + propertyId;
        String currentUser = this.userService.getUser().getName();
        PropertyDto propertyDto = new PropertyDto();
        this.commandDtoServiceInternal.addPropertyValue(property, propertyDto, newValueAdapterIfAny);
        ValueWithTypeDto newValue = propertyDto.getNewValue();
        return InteractionDtoUtils.newPropertyEdit((int)nextEventSequence, (Bookmark)targetBookmark, (String)targetTitle, (String)propertyDto.getMemberIdentifier(), (ValueWithTypeDto)newValue, (String)currentUser);
    }
}

