/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.memento;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.memento.MementoService;
import org.apache.isis.applib.services.urlencoding.UrlEncodingService;
import org.apache.isis.core.runtime.services.memento.Dom4jUtil;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

@DomainService(nature=NatureOfService.DOMAIN)
public class MementoServiceDefault
implements MementoService {
    private boolean noEncoding = false;
    @Inject
    UrlEncodingService urlEncodingService;

    @Programmatic
    public MementoServiceDefault withNoEncoding() {
        this.noEncoding = true;
        return this;
    }

    @Programmatic
    public MementoService.Memento create() {
        return new MementoDefault(this.noEncoding, this.urlEncodingService);
    }

    @Programmatic
    public MementoService.Memento parse(String str) {
        String xmlStr = this.noEncoding ? str : this.urlEncodingService.decode(str);
        Document doc = Dom4jUtil.parse(xmlStr);
        return new MementoDefault(doc, this.noEncoding, this.urlEncodingService);
    }

    @Programmatic
    public boolean canSet(Object input) {
        return input == null || Dom4jUtil.isSupportedClass(input.getClass());
    }

    static class MementoDefault
    implements MementoService.Memento {
        private final boolean noEncoding;
        private final Document doc;
        private final UrlEncodingService urlEncodingService;
        private static final Function<Element, String> ELEMENT_NAME = new Function<Element, String>(){

            public String apply(Element input) {
                return input.getName();
            }
        };

        MementoDefault(boolean noEncoding, UrlEncodingService urlEncodingService) {
            this(DocumentHelper.createDocument(), noEncoding, urlEncodingService);
            this.doc.addElement("memento");
        }

        MementoDefault(Document doc, boolean noEncoding, UrlEncodingService urlEncodingService) {
            this.doc = doc;
            this.noEncoding = noEncoding;
            this.urlEncodingService = urlEncodingService;
        }

        public MementoService.Memento set(String name, Object value) {
            Element el = this.doc.getRootElement();
            Dom4jUtil.addChild(el, name, value);
            return this;
        }

        public <T> T get(String name, Class<T> cls) {
            Element el = this.doc.getRootElement();
            return Dom4jUtil.getChild(el, name, cls);
        }

        public String asString() {
            String xmlStr = Dom4jUtil.asString(this.doc);
            return this.encode(xmlStr);
        }

        protected String encode(String xmlStr) {
            return this.noEncoding ? xmlStr : this.urlEncodingService.encode(xmlStr);
        }

        public Set<String> keySet() {
            Element element = this.doc.getRootElement();
            List elements = element.elements();
            return Sets.newLinkedHashSet((Iterable)Iterables.transform((Iterable)elements, ELEMENT_NAME));
        }

        public String toString() {
            return Dom4jUtil.asString(this.doc);
        }
    }
}

