/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.msgbroker;

import javax.inject.Inject;
import org.apache.isis.applib.RecoverableException;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.core.commons.authentication.MessageBroker;
import org.apache.isis.core.metamodel.services.msgbroker.MessageBrokerServiceInternal;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483646")
public class MessageBrokerServiceInternalDefault
implements MessageBrokerServiceInternal {
    @Inject
    IsisSessionFactory isisSessionFactory;

    public void informUser(String message) {
        this.getMessageBroker().addMessage(message);
    }

    public void warnUser(String message) {
        this.getMessageBroker().addWarning(message);
    }

    public void raiseError(String message) {
        throw new RecoverableException(message);
    }

    private MessageBroker getMessageBroker() {
        return this.isisSessionFactory.getCurrentSession().getAuthenticationSession().getMessageBroker();
    }
}

