/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.publish;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.PublishedAction;
import org.apache.isis.applib.annotation.PublishedObject;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.clock.ClockService;
import org.apache.isis.applib.services.command.Command;
import org.apache.isis.applib.services.command.CommandContext;
import org.apache.isis.applib.services.iactn.Interaction;
import org.apache.isis.applib.services.iactn.InteractionContext;
import org.apache.isis.applib.services.metrics.MetricsService;
import org.apache.isis.applib.services.publish.EventMetadata;
import org.apache.isis.applib.services.publish.EventPayload;
import org.apache.isis.applib.services.publish.EventType;
import org.apache.isis.applib.services.publish.ObjectStringifier;
import org.apache.isis.applib.services.publish.PublishedObjects;
import org.apache.isis.applib.services.publish.PublisherService;
import org.apache.isis.applib.services.publish.PublishingService;
import org.apache.isis.applib.services.user.UserService;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.oid.Oid;
import org.apache.isis.core.metamodel.adapter.oid.OidMarshaller;
import org.apache.isis.core.metamodel.adapter.oid.RootOid;
import org.apache.isis.core.metamodel.facetapi.IdentifiedHolder;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.FacetedMethodParameter;
import org.apache.isis.core.metamodel.facets.actions.action.invocation.CommandUtil;
import org.apache.isis.core.metamodel.facets.actions.publish.PublishedActionFacet;
import org.apache.isis.core.metamodel.facets.object.encodeable.EncodableFacet;
import org.apache.isis.core.metamodel.facets.object.publishedobject.PublishedObjectFacet;
import org.apache.isis.core.metamodel.services.ixn.InteractionDtoServiceInternal;
import org.apache.isis.core.metamodel.services.publishing.PublishingServiceInternal;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectMember;
import org.apache.isis.core.runtime.services.changes.ChangedObjectsServiceInternal;
import org.apache.isis.core.runtime.services.publish.PublishedObjectsDefault;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;

@DomainService(nature=NatureOfService.DOMAIN)
@RequestScoped
public class PublishingServiceInternalDefault
implements PublishingServiceInternal {
    private static final OidMarshaller OID_MARSHALLER = OidMarshaller.INSTANCE;
    boolean suppress;
    @Inject
    private List<PublisherService> publisherServices;
    @Inject
    private PublishingService publishingServiceIfAny;
    @Inject
    private ChangedObjectsServiceInternal changedObjectsServiceInternal;
    @Inject
    private InteractionDtoServiceInternal interactionDtoServiceInternal;
    @Inject
    private CommandContext commandContext;
    @Inject
    private InteractionContext interactionContext;
    @Inject
    private ClockService clockService;
    @Inject
    private UserService userService;
    @Inject
    private MetricsService metricsService;
    @Inject
    private IsisSessionFactory isisSessionFactory;

    private Function<ObjectAdapter, ObjectAdapter> notDestroyedElseEmpty() {
        return new Function<ObjectAdapter, ObjectAdapter>(){

            public ObjectAdapter apply(ObjectAdapter adapter) {
                if (adapter == null) {
                    return null;
                }
                if (!adapter.isDestroyed()) {
                    return adapter;
                }
                Object replacementObject = PublishingServiceInternalDefault.this.getPersistenceSession().instantiateAndInjectServices(adapter.getSpecification());
                PublishingServiceInternalDefault.this.getPersistenceSession().remapRecreatedPojo(adapter, replacementObject);
                return adapter;
            }
        };
    }

    @Programmatic
    public void publishObjects() {
        if (this.suppress) {
            return;
        }
        HashMap changeKindByEnlistedAdapter = Maps.newHashMap();
        changeKindByEnlistedAdapter.putAll(this.changedObjectsServiceInternal.getChangeKindByEnlistedAdapter());
        this.publishObjectsToPublishingService(changeKindByEnlistedAdapter);
        this.publishObjectsToPublisherServices(changeKindByEnlistedAdapter);
    }

    private void publishObjectsToPublishingService(Map<ObjectAdapter, PublishedObject.ChangeKind> changeKindByEnlistedAdapter) {
        if (this.publishingServiceIfAny == null) {
            return;
        }
        String currentUser = this.userService.getUser().getName();
        Timestamp timestamp = this.clockService.nowAsJavaSqlTimestamp();
        ObjectStringifier stringifier = this.objectStringifier();
        for (Map.Entry<ObjectAdapter, PublishedObject.ChangeKind> adapterAndChange : changeKindByEnlistedAdapter.entrySet()) {
            ObjectAdapter enlistedAdapter = adapterAndChange.getKey();
            PublishedObject.ChangeKind changeKind = adapterAndChange.getValue();
            this.publishObjectToPublishingService(enlistedAdapter, changeKind, currentUser, timestamp, stringifier);
        }
    }

    private void publishObjectToPublishingService(ObjectAdapter enlistedAdapter, PublishedObject.ChangeKind changeKind, String currentUser, Timestamp timestamp, ObjectStringifier stringifier) {
        PublishedObjectFacet publishedObjectFacet = (PublishedObjectFacet)enlistedAdapter.getSpecification().getFacet(PublishedObjectFacet.class);
        if (publishedObjectFacet == null) {
            return;
        }
        PublishedObject.PayloadFactory payloadFactory = (PublishedObject.PayloadFactory)publishedObjectFacet.value();
        RootOid enlistedAdapterOid = (RootOid)enlistedAdapter.getOid();
        String enlistedAdapterClass = CommandUtil.targetClassNameFor((ObjectAdapter)enlistedAdapter);
        Bookmark enlistedTarget = enlistedAdapterOid.asBookmark();
        EventMetadata metadata = this.newEventMetadata(currentUser, timestamp, changeKind, enlistedAdapterClass, enlistedTarget);
        Object pojo = ObjectAdapter.Util.unwrap((ObjectAdapter)this.undeletedElseEmpty(enlistedAdapter));
        EventPayload payload = payloadFactory.payloadFor(pojo, changeKind);
        payload.withStringifier(stringifier);
        this.publishingServiceIfAny.publish(metadata, payload);
    }

    private void publishObjectsToPublisherServices(Map<ObjectAdapter, PublishedObject.ChangeKind> changeKindByEnlistedAdapter) {
        Map changeKindByPublishedAdapter = Maps.filterKeys(changeKindByEnlistedAdapter, (Predicate)PublishedObjectFacet.Predicates.isPublished());
        if (changeKindByPublishedAdapter.isEmpty()) {
            return;
        }
        int numberLoaded = this.metricsService.numberObjectsLoaded();
        int numberObjectPropertiesModified = this.changedObjectsServiceInternal.numberObjectPropertiesModified();
        PublishedObjects publishedObjects = this.newPublishedObjects(numberLoaded, numberObjectPropertiesModified, changeKindByPublishedAdapter);
        for (PublisherService publisherService : this.publisherServices) {
            publisherService.publish(publishedObjects);
        }
    }

    private PublishedObjects newPublishedObjects(int numberLoaded, int numberObjectPropertiesModified, Map<ObjectAdapter, PublishedObject.ChangeKind> changeKindByPublishedAdapter) {
        Command command = this.commandContext.getCommand();
        UUID transactionUuid = command.getTransactionId();
        String userName = this.userService.getUser().getName();
        Timestamp timestamp = this.clockService.nowAsJavaSqlTimestamp();
        Interaction interaction = this.interactionContext.getInteraction();
        int nextEventSequence = interaction.next(Interaction.Sequence.INTERACTION.id());
        return new PublishedObjectsDefault(transactionUuid, nextEventSequence, userName, timestamp, numberLoaded, numberObjectPropertiesModified, changeKindByPublishedAdapter);
    }

    @Programmatic
    public void publishAction(Interaction.Execution execution, ObjectAction objectAction, IdentifiedHolder identifiedHolder, ObjectAdapter targetAdapter, List<ObjectAdapter> parameterAdapters, ObjectAdapter resultAdapter) {
        if (this.suppress) {
            return;
        }
        this.publishActionToPublishingService(objectAction, identifiedHolder, targetAdapter, parameterAdapters, resultAdapter);
        this.publishToPublisherServices(execution);
    }

    private void publishActionToPublishingService(ObjectAction objectAction, IdentifiedHolder identifiedHolder, ObjectAdapter targetAdapter, List<ObjectAdapter> parameterAdapters, ObjectAdapter resultAdapter) {
        List parameterTypes;
        List parameterNames;
        Class returnType;
        if (this.publishingServiceIfAny == null) {
            return;
        }
        String currentUser = this.userService.getUser().getName();
        Timestamp timestamp = this.clockService.nowAsJavaSqlTimestamp();
        PublishedActionFacet publishedActionFacet = (PublishedActionFacet)identifiedHolder.getFacet(PublishedActionFacet.class);
        if (publishedActionFacet == null) {
            return;
        }
        RootOid adapterOid = (RootOid)targetAdapter.getOid();
        String oidStr = OID_MARSHALLER.marshal(adapterOid);
        Identifier actionIdentifier = objectAction.getIdentifier();
        String title = oidStr + ": " + actionIdentifier.toNameParmsIdentityString();
        String actionTargetClass = CommandUtil.targetClassNameFor((ObjectAdapter)targetAdapter);
        String actionTargetAction = CommandUtil.targetMemberNameFor((ObjectMember)objectAction);
        Bookmark actionTarget = CommandUtil.bookmarkFor((ObjectAdapter)targetAdapter);
        String actionMemberIdentifier = CommandUtil.memberIdentifierFor((ObjectMember)objectAction);
        if (identifiedHolder instanceof FacetedMethod) {
            FacetedMethod facetedMethod = (FacetedMethod)identifiedHolder;
            returnType = facetedMethod.getType();
            List parameters = facetedMethod.getParameters();
            parameterNames = PublishingServiceInternalDefault.immutableList(Iterables.transform((Iterable)parameters, (Function)FacetedMethodParameter.Functions.GET_NAME));
            parameterTypes = PublishingServiceInternalDefault.immutableList(Iterables.transform((Iterable)parameters, (Function)FacetedMethodParameter.Functions.GET_TYPE));
        } else {
            parameterNames = null;
            parameterTypes = null;
            returnType = null;
        }
        Interaction interaction = this.interactionContext.getInteraction();
        int nextEventSequence = interaction.next(Interaction.Sequence.PUBLISHED_EVENT.id());
        UUID transactionId = interaction.getTransactionId();
        EventMetadata metadata = new EventMetadata(transactionId, nextEventSequence, EventType.ACTION_INVOCATION, currentUser, timestamp, title, actionTargetClass, actionTargetAction, actionTarget, actionMemberIdentifier, parameterNames, parameterTypes, returnType);
        PublishedAction.PayloadFactory payloadFactory = (PublishedAction.PayloadFactory)publishedActionFacet.value();
        ObjectStringifier stringifier = this.objectStringifier();
        EventPayload payload = payloadFactory.payloadFor(identifiedHolder.getIdentifier(), ObjectAdapter.Util.unwrap((ObjectAdapter)this.undeletedElseEmpty(targetAdapter)), ObjectAdapter.Util.unwrap(this.undeletedElseEmpty(parameterAdapters)), ObjectAdapter.Util.unwrap((ObjectAdapter)this.undeletedElseEmpty(resultAdapter)));
        payload.withStringifier(stringifier);
        this.publishingServiceIfAny.publish(metadata, payload);
    }

    private static <T> List<T> immutableList(Iterable<T> iterable) {
        return Collections.unmodifiableList(Lists.newArrayList(iterable));
    }

    private ObjectStringifier objectStringifier() {
        return new ObjectStringifier(){

            public String toString(Object object) {
                if (object == null) {
                    return null;
                }
                ObjectAdapter adapter = PublishingServiceInternalDefault.this.isisSessionFactory.getCurrentSession().getPersistenceSession().adapterFor(object);
                Oid oid = adapter.getOid();
                return oid != null ? oid.enString() : this.encodedValueOf(adapter);
            }

            private String encodedValueOf(ObjectAdapter adapter) {
                EncodableFacet facet = (EncodableFacet)adapter.getSpecification().getFacet(EncodableFacet.class);
                return facet != null ? facet.toEncodedString(adapter) : adapter.toString();
            }

            public String classNameOf(Object object) {
                ObjectAdapter adapter = PublishingServiceInternalDefault.this.getPersistenceSession().adapterFor(object);
                String className = adapter.getSpecification().getFullIdentifier();
                return className;
            }
        };
    }

    private List<ObjectAdapter> undeletedElseEmpty(List<ObjectAdapter> parameters) {
        return Lists.newArrayList((Iterable)Iterables.transform(parameters, this.notDestroyedElseEmpty()));
    }

    private ObjectAdapter undeletedElseEmpty(ObjectAdapter adapter) {
        return (ObjectAdapter)this.notDestroyedElseEmpty().apply((Object)adapter);
    }

    private EventMetadata newEventMetadata(String currentUser, Timestamp timestamp, PublishedObject.ChangeKind changeKind, String enlistedAdapterClass, Bookmark enlistedTarget) {
        EventType eventType = PublishingServiceInternalDefault.eventTypeFor(changeKind);
        Interaction interaction = this.interactionContext.getInteraction();
        int nextEventSequence = interaction.next(Interaction.Sequence.PUBLISHED_EVENT.id());
        UUID transactionId = interaction.getTransactionId();
        return new EventMetadata(transactionId, nextEventSequence, eventType, currentUser, timestamp, enlistedTarget.toString(), enlistedAdapterClass, null, enlistedTarget, null, null, null, null);
    }

    private static EventType eventTypeFor(PublishedObject.ChangeKind changeKind) {
        if (changeKind == PublishedObject.ChangeKind.UPDATE) {
            return EventType.OBJECT_UPDATED;
        }
        if (changeKind == PublishedObject.ChangeKind.CREATE) {
            return EventType.OBJECT_CREATED;
        }
        if (changeKind == PublishedObject.ChangeKind.DELETE) {
            return EventType.OBJECT_DELETED;
        }
        throw new IllegalArgumentException("unknown ChangeKind '" + changeKind + "'");
    }

    public void publishProperty(Interaction.Execution execution) {
        if (this.suppress) {
            return;
        }
        this.publishToPublisherServices(execution);
    }

    private void publishToPublisherServices(Interaction.Execution<?, ?> execution) {
        if (this.publisherServices == null || this.publisherServices.isEmpty()) {
            return;
        }
        for (PublisherService publisherService : this.publisherServices) {
            publisherService.publish(execution);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Programmatic
    public <T> T withPublishingSuppressed(PublishingServiceInternal.Block<T> block) {
        try {
            this.suppress = true;
            Object object = block.exec();
            return (T)object;
        }
        finally {
            this.suppress = false;
        }
    }

    private PersistenceSession getPersistenceSession() {
        return this.isisSessionFactory.getCurrentSession().getPersistenceSession();
    }
}

