/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.transtate;

import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.core.metamodel.services.transtate.TransactionStateProviderInternal;
import org.apache.isis.core.metamodel.transactions.TransactionState;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransaction;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;

@DomainService(nature=NatureOfService.DOMAIN, menuOrder="2147483646")
public class TransactionStateProviderInternalDefault
implements TransactionStateProviderInternal {
    @Inject
    IsisSessionFactory isisSessionFactory;

    public TransactionState getTransactionState() {
        IsisTransaction transaction = this.getTransactionManager().getCurrentTransaction();
        if (transaction == null) {
            return TransactionState.NONE;
        }
        IsisTransaction.State state = transaction.getState();
        return state.getRuntimeContextState();
    }

    private IsisTransactionManager getTransactionManager() {
        return this.getPersistenceSession().getTransactionManager();
    }

    private PersistenceSession getPersistenceSession() {
        return this.isisSessionFactory.getCurrentSession().getPersistenceSession();
    }
}

