/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.services.xmlsnapshot;

import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.NatureOfService;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.xmlsnapshot.XmlSnapshotService;
import org.apache.isis.applib.services.xmlsnapshot.XmlSnapshotServiceAbstract;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.runtime.snapshot.XmlSnapshot;
import org.apache.isis.core.runtime.snapshot.XmlSnapshotBuilder;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;

@DomainService(nature=NatureOfService.DOMAIN)
public class XmlSnapshotServiceDefault
extends XmlSnapshotServiceAbstract {
    @Inject
    IsisSessionFactory isisSessionFactory;

    @Programmatic
    public XmlSnapshotService.Snapshot snapshotFor(Object domainObject) {
        ObjectAdapter adapter = this.getPersistenceSession().adapterFor(domainObject);
        return new XmlSnapshot(adapter);
    }

    @Programmatic
    public XmlSnapshotService.Builder builderFor(Object domainObject) {
        return new XmlSnapshotServiceDefaultBuilder(domainObject);
    }

    protected PersistenceSession getPersistenceSession() {
        return this.isisSessionFactory.getCurrentSession().getPersistenceSession();
    }

    static class XmlSnapshotServiceDefaultBuilder
    implements XmlSnapshotService.Builder {
        private final XmlSnapshotBuilder builder;

        public XmlSnapshotServiceDefaultBuilder(Object domainObject) {
            this.builder = new XmlSnapshotBuilder(domainObject);
        }

        public void includePath(String path) {
            this.builder.includePath(path);
        }

        public void includePathAndAnnotation(String path, String annotation) {
            this.builder.includePathAndAnnotation(path, annotation);
        }

        public XmlSnapshotService.Snapshot build() {
            XmlSnapshot xmlSnapshot = this.builder.build();
            return xmlSnapshot;
        }
    }
}

