/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.isis.applib.query.Query;
import org.apache.isis.applib.query.QueryDefault;
import org.apache.isis.applib.query.QueryFindAllInstances;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.mgr.AdapterManager;
import org.apache.isis.core.metamodel.services.container.query.QueryCardinality;
import org.apache.isis.core.metamodel.services.container.query.QueryFindByPattern;
import org.apache.isis.core.metamodel.services.container.query.QueryFindByTitle;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindAllInstances;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindByPattern;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindByTitle;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindUsingApplibQueryDefault;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindUsingApplibQuerySerializable;
import org.apache.isis.core.runtime.system.persistence.PersistenceQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceQueryFactory {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceQueryFactory.class);
    private final SpecificationLoader specificationLoader;
    private final AdapterManager adapterManager;

    PersistenceQueryFactory(AdapterManager adapterManager, SpecificationLoader specificationLoader) {
        this.specificationLoader = specificationLoader;
        this.adapterManager = adapterManager;
    }

    final PersistenceQuery createPersistenceQueryFor(Query<?> query, QueryCardinality cardinality) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("createPersistenceQueryFor: " + query.getDescription());
        }
        ObjectSpecification noSpec = this.specFor(query);
        if (query instanceof QueryFindAllInstances) {
            QueryFindAllInstances queryFindAllInstances = (QueryFindAllInstances)query;
            return new PersistenceQueryFindAllInstances(noSpec, this.specificationLoader, queryFindAllInstances.getStart(), queryFindAllInstances.getCount());
        }
        if (query instanceof QueryFindByTitle) {
            QueryFindByTitle queryByTitle = (QueryFindByTitle)query;
            String title = queryByTitle.getTitle();
            return new PersistenceQueryFindByTitle(noSpec, title, this.specificationLoader, queryByTitle.getStart(), queryByTitle.getCount());
        }
        if (query instanceof QueryFindByPattern) {
            QueryFindByPattern queryByPattern = (QueryFindByPattern)query;
            Object pattern = queryByPattern.getPattern();
            ObjectAdapter patternAdapter = this.adapterManager.adapterFor(pattern);
            return new PersistenceQueryFindByPattern(noSpec, patternAdapter, this.specificationLoader, queryByPattern.getStart(), queryByPattern.getCount());
        }
        if (query instanceof QueryDefault) {
            QueryDefault queryDefault = (QueryDefault)query;
            String queryName = queryDefault.getQueryName();
            Map<String, ObjectAdapter> argumentsAdaptersByParameterName = this.wrap(queryDefault.getArgumentsByParameterName());
            return new PersistenceQueryFindUsingApplibQueryDefault(noSpec, queryName, argumentsAdaptersByParameterName, cardinality, this.specificationLoader, queryDefault.getStart(), queryDefault.getCount());
        }
        return new PersistenceQueryFindUsingApplibQuerySerializable(noSpec, query, cardinality, this.specificationLoader);
    }

    private Map<String, ObjectAdapter> wrap(Map<String, Object> argumentsByParameterName) {
        HashMap argumentsAdaptersByParameterName = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : argumentsByParameterName.entrySet()) {
            String parameterName = entry.getKey();
            Object argument = argumentsByParameterName.get(parameterName);
            ObjectAdapter argumentAdapter = argument != null ? this.adapterManager.adapterFor(argument) : null;
            argumentsAdaptersByParameterName.put(parameterName, argumentAdapter);
        }
        return argumentsAdaptersByParameterName;
    }

    private ObjectSpecification specFor(Query<?> query) {
        return this.specificationLoader.loadSpecification(query.getResultType());
    }
}

