/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import java.util.Map;
import java.util.Set;
import javax.jdo.PersistenceManagerFactory;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.components.ApplicationScopedComponent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.runtime.persistence.FixturesInstalledFlag;
import org.apache.isis.core.runtime.system.persistence.DataNucleusApplicationComponents;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.objectstore.jdo.datanucleus.JDOStateManagerForIsis;
import org.apache.isis.objectstore.jdo.service.RegisterEntities;
import org.datanucleus.api.jdo.JDOPersistenceManagerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceSessionFactory
implements ApplicationScopedComponent,
FixturesInstalledFlag {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceSessionFactory.class);
    private final IsisConfigurationDefault configuration;
    public static final String JDO_OBJECTSTORE_CONFIG_PREFIX = "isis.persistor.datanucleus";
    public static final String DATANUCLEUS_CONFIG_PREFIX = "isis.persistor.datanucleus.impl";
    private DataNucleusApplicationComponents applicationComponents;
    private Boolean fixturesInstalled;

    public PersistenceSessionFactory(IsisConfigurationDefault isisConfiguration) {
        this.configuration = isisConfiguration;
    }

    @Programmatic
    public void init(SpecificationLoader specificationLoader) {
        this.applicationComponents = this.createDataNucleusApplicationComponents((IsisConfiguration)this.configuration, specificationLoader);
    }

    @Programmatic
    public boolean isInitialized() {
        return this.applicationComponents != null;
    }

    private DataNucleusApplicationComponents createDataNucleusApplicationComponents(IsisConfiguration configuration, SpecificationLoader specificationLoader) {
        if (this.applicationComponents == null || this.applicationComponents.isStale()) {
            IsisConfiguration jdoObjectstoreConfig = configuration.createSubset(JDO_OBJECTSTORE_CONFIG_PREFIX);
            IsisConfiguration dataNucleusConfig = configuration.createSubset(DATANUCLEUS_CONFIG_PREFIX);
            Map datanucleusProps = dataNucleusConfig.asMap();
            PersistenceSessionFactory.addDataNucleusPropertiesIfRequired(datanucleusProps);
            RegisterEntities registerEntities = new RegisterEntities(configuration.asMap(), specificationLoader);
            Set<String> classesToBePersisted = registerEntities.getEntityTypes();
            this.applicationComponents = new DataNucleusApplicationComponents(jdoObjectstoreConfig, specificationLoader, datanucleusProps, classesToBePersisted);
        }
        return this.applicationComponents;
    }

    private static void addDataNucleusPropertiesIfRequired(Map<String, String> props) {
        PersistenceSessionFactory.putIfNotPresent(props, "datanucleus.objectProvider.className", JDOStateManagerForIsis.class.getName());
        PersistenceSessionFactory.putIfNotPresent(props, "javax.jdo.PersistenceManagerFactoryClass", JDOPersistenceManagerFactory.class.getName());
        PersistenceSessionFactory.putIfNotPresent(props, "datanucleus.schema.autoCreateSchema", Boolean.FALSE.toString());
        PersistenceSessionFactory.putIfNotPresent(props, "datanucleus.schema.validateAll", Boolean.TRUE.toString());
        PersistenceSessionFactory.putIfNotPresent(props, "datanucleus.cache.level2.type", "none");
        PersistenceSessionFactory.putIfNotPresent(props, "datanucleus.persistenceUnitLoadClasses", Boolean.TRUE.toString());
        String connectionFactoryName = props.get("datanucleus.ConnectionFactoryName");
        if (connectionFactoryName != null) {
            String connectionFactory2Name = props.get("datanucleus.ConnectionFactory2Name");
            String transactionType = props.get("javax.jdo.option.TransactionType");
            if (transactionType == null) {
                LOG.info("found config properties to use non-JTA JNDI datasource (" + connectionFactoryName + ")");
                if (connectionFactory2Name != null) {
                    LOG.warn("found config properties to use non-JTA JNDI datasource (" + connectionFactoryName + "); second '-nontx' JNDI datasource also configured but will not be used (" + connectionFactory2Name + ")");
                }
            } else {
                LOG.info("found config properties to use JTA JNDI datasource (" + connectionFactoryName + ")");
            }
            if (connectionFactory2Name == null) {
                LOG.error("found config properties to use JTA JNDI datasource (" + connectionFactoryName + ") but config properties for second '-nontx' JNDI datasource were *not* found");
            } else {
                LOG.info("... and config properties for second '-nontx' JNDI datasource also found; " + connectionFactory2Name);
            }
            return;
        }
        LOG.info("did *not* find config properties to use JNDI datasource; will use JDBC");
        PersistenceSessionFactory.putIfNotPresent(props, "javax.jdo.option.ConnectionDriverName", "org.hsqldb.jdbcDriver");
        PersistenceSessionFactory.putIfNotPresent(props, "javax.jdo.option.ConnectionURL", "jdbc:hsqldb:mem:test");
        PersistenceSessionFactory.putIfNotPresent(props, "javax.jdo.option.ConnectionUserName", "sa");
        PersistenceSessionFactory.putIfNotPresent(props, "javax.jdo.option.ConnectionPassword", "");
    }

    private static void putIfNotPresent(Map<String, String> props, String key, String value) {
        if (!props.containsKey(key)) {
            props.put(key, value);
        }
    }

    @Programmatic
    public final void shutdown() {
    }

    @Programmatic
    public PersistenceSession createPersistenceSession(ServicesInjector servicesInjector, AuthenticationSession authenticationSession) {
        PersistenceSessionFactory fixturesInstalledFlag = this;
        PersistenceManagerFactory persistenceManagerFactory = this.applicationComponents.getPersistenceManagerFactory();
        return new PersistenceSession(servicesInjector, authenticationSession, persistenceManagerFactory, fixturesInstalledFlag);
    }

    @Override
    @Programmatic
    public Boolean isFixturesInstalled() {
        return this.fixturesInstalled;
    }

    @Override
    @Programmatic
    public void setFixturesInstalled(Boolean fixturesInstalled) {
        this.fixturesInstalled = fixturesInstalled;
    }
}

