/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.persistence;

import java.sql.Timestamp;
import java.util.Date;
import javax.jdo.listener.InstanceLifecycleEvent;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.metamodel.adapter.version.Version;
import org.datanucleus.enhancement.Persistable;

public class Utils {
    private static Object jdoObjectIdFor(InstanceLifecycleEvent event) {
        Persistable persistenceCapable = Utils.persistenceCapableFor(event);
        Object jdoObjectId = persistenceCapable.dnGetObjectId();
        return jdoObjectId;
    }

    static Persistable persistenceCapableFor(InstanceLifecycleEvent event) {
        return (Persistable)event.getSource();
    }

    static Version getVersionIfAny(Persistable pojo, AuthenticationSession authenticationSession) {
        Object jdoVersion = pojo.dnGetVersion();
        if (jdoVersion instanceof Long) {
            Long longVersion = (Long)jdoVersion;
            return Version.create((Long)longVersion, (String)authenticationSession.getUserName(), (Date)null);
        }
        if (jdoVersion instanceof Timestamp) {
            Timestamp timestampVersion = (Timestamp)jdoVersion;
            return Version.create((Long)timestampVersion.getTime(), (String)authenticationSession.getUserName(), (Date)null);
        }
        return null;
    }
}

