/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.session;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.fixtures.FixtureClock;
import org.apache.isis.applib.fixturescripts.FixtureScripts;
import org.apache.isis.applib.services.fixturespec.FixtureScriptsDefault;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.commons.lang.ListExtensions;
import org.apache.isis.core.metamodel.deployment.DeploymentCategory;
import org.apache.isis.core.metamodel.deployment.DeploymentCategoryProvider;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.configinternal.ConfigurationServiceInternal;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelInvalidException;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.apache.isis.core.runtime.services.deplcat.DeploymentCategoryProviderDefault;
import org.apache.isis.core.runtime.system.IsisSystemException;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.internal.IsisLocaleInitializer;
import org.apache.isis.core.runtime.system.internal.IsisTimeZoneInitializer;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactoryMetamodelRefiner;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.runtime.systemusinginstallers.IsisComponentProvider;
import org.apache.isis.core.runtime.systemusinginstallers.IsisComponentProviderDefault2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisSessionFactoryBuilder {
    public static final Logger LOG = LoggerFactory.getLogger(IsisSessionFactoryBuilder.class);
    private boolean initialized = false;
    private final IsisComponentProvider componentProvider;
    private final DeploymentCategory deploymentCategory;
    private final IsisLocaleInitializer localeInitializer;
    private final IsisTimeZoneInitializer timeZoneInitializer;

    public IsisSessionFactoryBuilder(AppManifest manifest) {
        this(new IsisComponentProviderDefault2(manifest, null), DeploymentCategory.PRODUCTION);
    }

    public IsisSessionFactoryBuilder(IsisComponentProvider componentProvider, DeploymentCategory deploymentCategory) {
        this.componentProvider = componentProvider;
        this.deploymentCategory = deploymentCategory;
        this.localeInitializer = new IsisLocaleInitializer();
        this.timeZoneInitializer = new IsisTimeZoneInitializer();
    }

    public DeploymentCategory getDeploymentCategory() {
        return this.deploymentCategory;
    }

    public IsisSessionFactory buildSessionFactory() {
        IsisSessionFactory isisSessionFactory;
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.initialized = true;
        LOG.info("initialising Isis System");
        LOG.info("working directory: " + new File(".").getAbsolutePath());
        IsisConfigurationDefault configuration = this.componentProvider.getConfiguration();
        LOG.info("resource stream source: " + configuration.getResourceStreamSource());
        this.localeInitializer.initLocale((IsisConfiguration)configuration);
        this.timeZoneInitializer.initTimeZone((IsisConfiguration)configuration);
        if (!this.getDeploymentCategory().isProduction() && !Clock.isInitialized()) {
            FixtureClock.initialize();
        }
        try {
            ServicesInjector servicesInjector = this.componentProvider.provideServiceInjector((IsisConfiguration)configuration);
            servicesInjector.addFallbackIfRequired(DeploymentCategoryProvider.class, (Object)new DeploymentCategoryProviderDefault(this.deploymentCategory));
            servicesInjector.addFallbackIfRequired(ConfigurationServiceInternal.class, (Object)configuration);
            servicesInjector.addFallbackIfRequired(FixtureScripts.class, (Object)new FixtureScriptsDefault());
            AuthenticationManager authenticationManager = this.componentProvider.provideAuthenticationManager();
            servicesInjector.addFallbackIfRequired(AuthenticationManager.class, (Object)authenticationManager);
            AuthorizationManager authorizationManager = this.componentProvider.provideAuthorizationManager();
            servicesInjector.addFallbackIfRequired(AuthorizationManager.class, (Object)authorizationManager);
            Collection<MetaModelRefiner> metaModelRefiners = IsisSessionFactoryBuilder.refiners(authenticationManager, authorizationManager, new PersistenceSessionFactoryMetamodelRefiner());
            SpecificationLoader specificationLoader = this.componentProvider.provideSpecificationLoader(servicesInjector, metaModelRefiners);
            servicesInjector.addFallbackIfRequired(SpecificationLoader.class, (Object)specificationLoader);
            PersistenceSessionFactory persistenceSessionFactory = new PersistenceSessionFactory(configuration);
            servicesInjector.addFallbackIfRequired(PersistenceSessionFactory.class, (Object)persistenceSessionFactory);
            servicesInjector.validateServices();
            isisSessionFactory = new IsisSessionFactory(this.deploymentCategory, servicesInjector);
            servicesInjector.addFallbackIfRequired(IsisSessionFactory.class, (Object)isisSessionFactory);
            servicesInjector.autowire();
            IsisContext.setSessionFactory(isisSessionFactory);
            try {
                specificationLoader.init();
                specificationLoader.validateAndAssert();
            }
            catch (MetaModelInvalidException ex) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Meta model invalid", (Throwable)ex);
                }
                IsisContext.setMetaModelInvalidException(ex);
            }
            authenticationManager.init(this.deploymentCategory);
            authorizationManager.init(this.deploymentCategory);
            persistenceSessionFactory.init(specificationLoader);
            isisSessionFactory.constructServices();
        }
        catch (IsisSystemException ex) {
            LOG.error("failed to initialise", (Throwable)ex);
            throw new RuntimeException(ex);
        }
        return isisSessionFactory;
    }

    private static Collection<MetaModelRefiner> refiners(Object ... possibleRefiners) {
        return ListExtensions.filtered(Arrays.asList(possibleRefiners), MetaModelRefiner.class);
    }

    public boolean isMetaModelValid() {
        return IsisContext.getMetaModelInvalidExceptionIfAny() == null;
    }
}

