/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.system.transaction;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.WithTransactionScope;
import org.apache.isis.applib.services.xactn.Transaction;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.authentication.MessageBroker;
import org.apache.isis.core.commons.components.TransactionScopedComponent;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.services.publishing.PublishingServiceInternal;
import org.apache.isis.core.metamodel.transactions.TransactionState;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.CreateObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.DestroyObjectCommand;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.PersistenceCommand;
import org.apache.isis.core.runtime.services.auditing.AuditingServiceInternal;
import org.apache.isis.core.runtime.services.persistsession.PersistenceSessionServiceInternalDefault;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionFlushException;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsisTransaction
implements TransactionScopedComponent,
Transaction {
    private static final Logger LOG = LoggerFactory.getLogger(IsisTransaction.class);
    private final UUID interactionId;
    private final int sequence;
    private final AuthenticationSession authenticationSession;
    private final List<PersistenceCommand> persistenceCommands = Lists.newArrayList();
    private final IsisTransactionManager transactionManager;
    private final MessageBroker messageBroker;
    private final PublishingServiceInternal publishingServiceInternal;
    private final AuditingServiceInternal auditingServiceInternal;
    private final List<WithTransactionScope> withTransactionScopes;
    private IsisException abortCause;
    private State state;

    public IsisTransaction(UUID interactionId, int sequence, AuthenticationSession authenticationSession, ServicesInjector servicesInjector) {
        this.interactionId = interactionId;
        this.sequence = sequence;
        this.authenticationSession = authenticationSession;
        PersistenceSessionServiceInternalDefault persistenceSessionService = (PersistenceSessionServiceInternalDefault)servicesInjector.lookupServiceElseFail(PersistenceSessionServiceInternalDefault.class);
        this.transactionManager = persistenceSessionService.getTransactionManager();
        this.messageBroker = authenticationSession.getMessageBroker();
        this.publishingServiceInternal = (PublishingServiceInternal)servicesInjector.lookupServiceElseFail(PublishingServiceInternal.class);
        this.auditingServiceInternal = (AuditingServiceInternal)servicesInjector.lookupServiceElseFail(AuditingServiceInternal.class);
        this.withTransactionScopes = servicesInjector.lookupServices(WithTransactionScope.class);
        this.state = State.IN_PROGRESS;
        if (LOG.isDebugEnabled()) {
            LOG.debug("new transaction " + this);
        }
    }

    @Programmatic
    public final UUID getTransactionId() {
        return this.interactionId;
    }

    public void setTransactionId(UUID transactionId) {
        throw new IllegalStateException("Transaction Id cannot be set on Transaction object");
    }

    public int getSequence() {
        return this.sequence;
    }

    public State getState() {
        return this.state;
    }

    private void setState(State state) {
        this.state = state;
    }

    public void addCommand(PersistenceCommand command) {
        if (command == null) {
            return;
        }
        ObjectAdapter onObject = command.onAdapter();
        if (command instanceof DestroyObjectCommand) {
            if (this.alreadyHasCreate(onObject)) {
                this.removeCreate(onObject);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ignored both create and destroy command " + command);
                }
                return;
            }
            if (this.alreadyHasDestroy(onObject)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ignored command " + command + " as command already recorded");
                }
                return;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("add command " + command);
        }
        this.persistenceCommands.add(command);
    }

    private boolean alreadyHasCommand(Class<?> commandClass, ObjectAdapter onObject) {
        return this.getCommand(commandClass, onObject) != null;
    }

    private boolean alreadyHasCreate(ObjectAdapter onObject) {
        return this.alreadyHasCommand(CreateObjectCommand.class, onObject);
    }

    private boolean alreadyHasDestroy(ObjectAdapter onObject) {
        return this.alreadyHasCommand(DestroyObjectCommand.class, onObject);
    }

    private PersistenceCommand getCommand(Class<?> commandClass, ObjectAdapter onObject) {
        for (PersistenceCommand command : this.persistenceCommands) {
            if (!command.onAdapter().equals(onObject) || !commandClass.isAssignableFrom(command.getClass())) continue;
            return command;
        }
        return null;
    }

    private void removeCommand(Class<?> commandClass, ObjectAdapter onObject) {
        PersistenceCommand toDelete = this.getCommand(commandClass, onObject);
        this.persistenceCommands.remove(toDelete);
    }

    private void removeCreate(ObjectAdapter onObject) {
        this.removeCommand(CreateObjectCommand.class, onObject);
    }

    public final void flush() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("flush transaction " + this);
        }
        try {
            this.doFlush();
        }
        catch (RuntimeException ex) {
            this.setAbortCause(new IsisTransactionFlushException(ex));
            throw ex;
        }
    }

    private void doFlush() {
        do {
            ArrayList persistenceCommandList;
            if ((persistenceCommandList = Lists.newArrayList(this.persistenceCommands)).isEmpty()) continue;
            this.persistenceCommands.removeAll(persistenceCommandList);
            try {
                this.transactionManager.getPersistenceSession().execute(persistenceCommandList);
                for (PersistenceCommand persistenceCommand : persistenceCommandList) {
                    if (!(persistenceCommand instanceof DestroyObjectCommand)) continue;
                    ObjectAdapter adapter = persistenceCommand.onAdapter();
                    adapter.setVersion(null);
                }
            }
            catch (RuntimeException ex) {
                this.persistenceCommands.clear();
                throw ex;
            }
        } while (!this.persistenceCommands.isEmpty());
    }

    void preCommit() {
        assert (this.getState().canCommit());
        assert (this.abortCause == null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("preCommit transaction " + this);
        }
        if (this.getState() == State.COMMITTED) {
            if (LOG.isInfoEnabled()) {
                LOG.info("already committed; ignoring");
            }
            return;
        }
        try {
            this.auditingServiceInternal.audit();
            this.publishingServiceInternal.publishObjects();
            this.doFlush();
        }
        catch (RuntimeException ex) {
            this.setAbortCause(new IsisTransactionManagerException(ex));
            throw ex;
        }
        finally {
            for (WithTransactionScope withTransactionScope : this.withTransactionScopes) {
                withTransactionScope.resetForNextTransaction();
            }
        }
    }

    void commit() {
        assert (this.getState().canCommit());
        assert (this.abortCause == null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("postCommit transaction " + this);
        }
        if (this.getState() == State.COMMITTED) {
            if (LOG.isInfoEnabled()) {
                LOG.info("already committed; ignoring");
            }
            return;
        }
        this.setState(State.COMMITTED);
    }

    final void markAsAborted() {
        assert (this.getState().canAbort());
        if (LOG.isInfoEnabled()) {
            LOG.info("abort transaction " + this);
        }
        this.setState(State.ABORTED);
    }

    public void setAbortCause(IsisException abortCause) {
        this.setState(State.MUST_ABORT);
        this.abortCause = abortCause;
    }

    public IsisException getAbortCause() {
        return this.abortCause;
    }

    public void clearAbortCause() {
        this.abortCause = null;
    }

    public void clearAbortCauseAndContinue() {
        this.setState(State.IN_PROGRESS);
        this.clearAbortCause();
    }

    public String toString() {
        return this.appendTo(new ToString((Object)this)).toString();
    }

    private ToString appendTo(ToString str) {
        str.append("state", (Object)this.state);
        str.append("commands", this.persistenceCommands.size());
        return str;
    }

    public MessageBroker getMessageBroker() {
        return this.messageBroker;
    }

    public static enum State {
        IN_PROGRESS(TransactionState.IN_PROGRESS),
        MUST_ABORT(TransactionState.MUST_ABORT),
        COMMITTED(TransactionState.COMMITTED),
        ABORTED(TransactionState.ABORTED);

        public final TransactionState transactionState;

        private State(TransactionState transactionState) {
            this.transactionState = transactionState;
        }

        public boolean canCommit() {
            return this == IN_PROGRESS;
        }

        public boolean canAbort() {
            return this == IN_PROGRESS || this == MUST_ABORT;
        }

        public boolean isComplete() {
            return this == COMMITTED || this == ABORTED;
        }

        public boolean mustAbort() {
            return this == MUST_ABORT;
        }

        public TransactionState getRuntimeContextState() {
            return this.transactionState;
        }
    }

    public static class Placeholder {
        public static Placeholder NEW = new Placeholder("[NEW]");
        public static Placeholder DELETED = new Placeholder("[DELETED]");
        private final String str;

        public Placeholder(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

