/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.systemusinginstallers;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.jdo.annotations.PersistenceCapable;
import org.apache.isis.applib.AppManifest;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.Mixin;
import org.apache.isis.applib.annotation.Nature;
import org.apache.isis.applib.fixturescripts.FixtureScript;
import org.apache.isis.applib.services.classdiscovery.ClassDiscoveryServiceUsingReflections;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.config.IsisConfigurationDefault;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.commons.lang.ClassUtil;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.layoutmetadata.LayoutMetadataReader;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.services.ServicesInjector;
import org.apache.isis.core.metamodel.specloader.ReflectorConstants;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidator;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.apache.isis.core.runtime.services.ServicesInstallerFromConfigurationAndAnnotation;
import org.apache.isis.core.runtime.system.IsisSystemException;
import org.apache.isis.progmodels.dflt.JavaReflectorHelper;
import org.apache.isis.progmodels.dflt.ProgrammingModelFacetsJava5;
import org.reflections.Reflections;
import org.reflections.vfs.Vfs;

public abstract class IsisComponentProvider {
    private final AppManifest appManifest;
    private final IsisConfigurationDefault configuration;
    protected final List<Object> services;
    protected final AuthenticationManager authenticationManager;
    protected final AuthorizationManager authorizationManager;

    public IsisComponentProvider(AppManifest appManifest, IsisConfiguration configuration, AuthenticationManager authenticationManager, AuthorizationManager authorizationManager) {
        if (appManifest == null) {
            throw new IllegalArgumentException("AppManifest is required");
        }
        this.appManifest = appManifest;
        this.configuration = (IsisConfigurationDefault)configuration;
        this.putAppManifestKey(appManifest);
        this.findAndRegisterTypes(appManifest);
        this.specifyServicesAndRegisteredEntitiesUsing(appManifest);
        this.overrideConfigurationUsing(appManifest);
        this.services = new ServicesInstallerFromConfigurationAndAnnotation(this.getConfiguration()).getServices();
        String fixtureClassNamesCsv = this.classNamesFrom(this.getAppManifest().getFixtures());
        this.putConfigurationProperty("isis.fixtures", fixtureClassNamesCsv);
        this.authenticationManager = authenticationManager;
        this.authorizationManager = authorizationManager;
    }

    public AppManifest getAppManifest() {
        return this.appManifest;
    }

    public IsisConfigurationDefault getConfiguration() {
        return this.configuration;
    }

    private void putAppManifestKey(AppManifest appManifest) {
        this.putConfigurationProperty("isis.appManifest", appManifest.getClass().getName());
    }

    private void findAndRegisterTypes(AppManifest appManifest) {
        Iterable<String> packageNameList = this.modulePackageNamesFrom(appManifest);
        AppManifest.Registry registry = AppManifest.Registry.instance();
        ArrayList packages = Lists.newArrayList();
        packages.addAll(AppManifest.Registry.FRAMEWORK_PROVIDED_SERVICES);
        Iterables.addAll((Collection)packages, packageNameList);
        Vfs.setDefaultURLTypes((List)ClassDiscoveryServiceUsingReflections.getUrlTypes());
        Reflections reflections = new Reflections(new Object[]{packages});
        Set domainServiceTypes = reflections.getTypesAnnotatedWith(DomainService.class);
        Set persistenceCapableTypes = reflections.getTypesAnnotatedWith(PersistenceCapable.class);
        Set fixtureScriptTypes = reflections.getSubTypesOf(FixtureScript.class);
        HashSet mixinTypes = Sets.newHashSet();
        mixinTypes.addAll(reflections.getTypesAnnotatedWith(Mixin.class));
        Set domainObjectTypes = reflections.getTypesAnnotatedWith(DomainObject.class);
        mixinTypes.addAll(Lists.newArrayList((Iterable)Iterables.filter((Iterable)domainObjectTypes, (Predicate)new Predicate<Class<?>>(){

            public boolean apply(@Nullable Class<?> input) {
                if (input == null) {
                    return false;
                }
                DomainObject annotation = input.getAnnotation(DomainObject.class);
                return annotation.nature() == Nature.MIXIN;
            }
        })));
        registry.setDomainServiceTypes(domainServiceTypes);
        registry.setPersistenceCapableTypes(persistenceCapableTypes);
        registry.setFixtureScriptTypes(fixtureScriptTypes);
        registry.setMixinTypes((Set)mixinTypes);
    }

    private void specifyServicesAndRegisteredEntitiesUsing(AppManifest appManifest) {
        Iterable<String> packageNames = this.modulePackageNamesFrom(appManifest);
        String packageNamesCsv = Joiner.on((char)',').join(packageNames);
        this.putConfigurationProperty("isis.services.ServicesInstallerFromAnnotation.packagePrefix", packageNamesCsv);
        this.putConfigurationProperty("isis.persistor.datanucleus.RegisterEntities.packagePrefix", packageNamesCsv);
        List additionalServices = appManifest.getAdditionalServices();
        if (additionalServices != null) {
            this.putConfigurationProperty("isis.services", this.classNamesFrom(additionalServices));
        }
    }

    private Iterable<String> modulePackageNamesFrom(AppManifest appManifest) {
        List modules = appManifest.getModules();
        if (modules == null || modules.isEmpty()) {
            throw new IllegalArgumentException("If an appManifest is provided then it must return a non-empty set of modules");
        }
        return Iterables.transform((Iterable)modules, (Function)ClassUtil.Functions.packageNameOf());
    }

    protected String classNamesFrom(List<?> objectsOrClasses) {
        if (objectsOrClasses == null) {
            return null;
        }
        Iterable fixtureClassNames = Iterables.transform(objectsOrClasses, IsisComponentProvider.classNameOf());
        return Joiner.on((char)',').join(fixtureClassNames);
    }

    private static Function<Object, String> classNameOf() {
        return new Function<Object, String>(){

            @Nullable
            public String apply(Object input) {
                Class<?> aClass = input instanceof Class ? (Class<?>)input : input.getClass();
                return aClass.getName();
            }
        };
    }

    private void overrideConfigurationUsing(AppManifest appManifest) {
        Map configurationProperties = appManifest.getConfigurationProperties();
        if (configurationProperties != null) {
            for (Map.Entry configProp : configurationProperties.entrySet()) {
                this.putConfigurationProperty((String)configProp.getKey(), (String)configProp.getValue());
            }
        }
    }

    void putConfigurationProperty(String key, String value) {
        if (value == null) {
            return;
        }
        this.configuration.put(key, value);
    }

    public AuthenticationManager provideAuthenticationManager() {
        return this.authenticationManager;
    }

    public AuthorizationManager provideAuthorizationManager() {
        return this.authorizationManager;
    }

    public ServicesInjector provideServiceInjector(IsisConfiguration configuration) {
        return new ServicesInjector(this.services, configuration);
    }

    public SpecificationLoader provideSpecificationLoader(ServicesInjector servicesInjector, Collection<MetaModelRefiner> metaModelRefiners) throws IsisSystemException {
        ProgrammingModel programmingModel = this.createProgrammingModel();
        MetaModelValidator mmv = this.createMetaModelValidator();
        List<LayoutMetadataReader> layoutMetadataReaders = this.createLayoutMetadataReaders();
        return JavaReflectorHelper.createObjectReflector((IsisConfiguration)this.configuration, (ProgrammingModel)programmingModel, metaModelRefiners, layoutMetadataReaders, (MetaModelValidator)mmv, (ServicesInjector)servicesInjector);
    }

    protected MetaModelValidator createMetaModelValidator() {
        String metaModelValidatorClassName = this.configuration.getString("isis.reflector.validator", ReflectorConstants.META_MODEL_VALIDATOR_CLASS_NAME_DEFAULT);
        return (MetaModelValidator)InstanceUtil.createInstance((String)metaModelValidatorClassName, MetaModelValidator.class, (Object[])new Object[0]);
    }

    protected ProgrammingModel createProgrammingModel() {
        ProgrammingModelFacetsJava5 programmingModel = new ProgrammingModelFacetsJava5((IsisConfiguration)this.configuration);
        ProgrammingModel.Util.includeFacetFactories((IsisConfiguration)this.configuration, (ProgrammingModel)programmingModel);
        ProgrammingModel.Util.excludeFacetFactories((IsisConfiguration)this.configuration, (ProgrammingModel)programmingModel);
        return programmingModel;
    }

    protected List<LayoutMetadataReader> createLayoutMetadataReaders() {
        ArrayList layoutMetadataReaders = Lists.newArrayList();
        String[] layoutMetadataReaderClassNames = this.configuration.getList("isis.reflector.layoutMetadataReaders", ReflectorConstants.LAYOUT_METADATA_READER_LIST_DEFAULT);
        if (layoutMetadataReaderClassNames != null) {
            for (String layoutMetadataReaderClassName : layoutMetadataReaderClassNames) {
                LayoutMetadataReader layoutMetadataReader = (LayoutMetadataReader)InstanceUtil.createInstance((String)layoutMetadataReaderClassName, LayoutMetadataReader.class, (Object[])new Object[0]);
                layoutMetadataReaders.add(layoutMetadataReader);
            }
        }
        return layoutMetadataReaders;
    }
}

