/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp.auth;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.webapp.auth.AuthenticationSessionStrategy;

public abstract class AuthenticationSessionStrategyAbstract
implements AuthenticationSessionStrategy {
    public static final int STATUS_UNAUTHORIZED = 401;

    protected HttpSession getHttpSession(ServletRequest servletRequest) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        return httpServletRequest.getSession();
    }

    protected ServletContext getServletContext(ServletRequest servletRequest) {
        HttpSession httpSession = this.getHttpSession(servletRequest);
        return httpSession.getServletContext();
    }

    @Override
    public void bind(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticationSession authSession) {
    }

    @Override
    public void invalidate(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.bind(httpServletRequest, httpServletResponse, null);
        httpServletResponse.setStatus(401);
    }

    protected AuthenticationManager authenticationManagerFrom(HttpServletRequest httpServletRequest) {
        return this.isisSessionFactoryFrom(httpServletRequest).getAuthenticationManager();
    }

    protected IsisSessionFactory isisSessionFactoryFrom(HttpServletRequest httpServletRequest) {
        return IsisContext.getSessionFactory();
    }
}

