/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.webapp.auth;

import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.isis.applib.fixtures.LogonFixture;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authentication.AuthenticationRequest;
import org.apache.isis.core.runtime.authentication.exploration.AuthenticationRequestExploration;
import org.apache.isis.core.runtime.fixtures.authentication.AuthenticationRequestLogonFixture;
import org.apache.isis.core.runtime.system.session.IsisSessionFactory;
import org.apache.isis.core.webapp.WebAppConstants;
import org.apache.isis.core.webapp.auth.AuthenticationSessionStrategyAbstract;

public class AuthenticationSessionStrategyDefault
extends AuthenticationSessionStrategyAbstract {
    @Override
    public AuthenticationSession lookupValid(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        boolean loggedInUsingLogonFixture;
        boolean sessionValid;
        AuthenticationManager authenticationManager = this.authenticationManagerFrom(httpServletRequest);
        HttpSession httpSession = this.getHttpSession((ServletRequest)httpServletRequest);
        AuthenticationSession authSession = (AuthenticationSession)httpSession.getAttribute(WebAppConstants.HTTP_SESSION_AUTHENTICATION_SESSION_KEY);
        if (authSession != null && (sessionValid = authenticationManager.isSessionValid(authSession))) {
            return authSession;
        }
        ServletContext servletContext = this.getServletContext((ServletRequest)httpServletRequest);
        IsisSessionFactory sessionFactory = (IsisSessionFactory)servletContext.getAttribute(WebAppConstants.ISIS_SESSION_FACTORY);
        if (sessionFactory == null) {
            return null;
        }
        LogonFixture logonFixture = sessionFactory.getLogonFixture();
        if (sessionFactory.getDeploymentCategory().isExploring() && (authSession = authenticationManager.authenticate((AuthenticationRequest)new AuthenticationRequestExploration(logonFixture))) != null) {
            return authSession;
        }
        boolean bl = loggedInUsingLogonFixture = httpSession.getAttribute(WebAppConstants.HTTP_SESSION_LOGGED_ON_PREVIOUSLY_USING_LOGON_FIXTURE_KEY) != null;
        if (logonFixture != null && !loggedInUsingLogonFixture) {
            httpSession.setAttribute(WebAppConstants.HTTP_SESSION_LOGGED_ON_PREVIOUSLY_USING_LOGON_FIXTURE_KEY, (Object)true);
            return authenticationManager.authenticate((AuthenticationRequest)new AuthenticationRequestLogonFixture(logonFixture));
        }
        return null;
    }

    @Override
    public void bind(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, AuthenticationSession authSession) {
        HttpSession httpSession = this.getHttpSession((ServletRequest)httpServletRequest);
        if (authSession != null) {
            httpSession.setAttribute(WebAppConstants.HTTP_SESSION_AUTHENTICATION_SESSION_KEY, (Object)authSession);
        } else {
            httpSession.removeAttribute(WebAppConstants.HTTP_SESSION_AUTHENTICATION_SESSION_KEY);
        }
    }
}

