/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.metamodel;

import java.text.MessageFormat;
import java.util.List;
import org.apache.isis.applib.filter.Filter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.Contributed;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.objectstore.jdo.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;
import org.apache.isis.objectstore.jdo.metamodel.util.JdoPrimaryKeyPropertyFilter;

public final class JdoPropertyUtils {
    private JdoPropertyUtils() {
    }

    public static OneToOneAssociation getPrimaryKeyPropertyFor(ObjectSpecification objectSpec) {
        return JdoPropertyUtils.getPropertyFor(objectSpec, "@PrimaryKey", (Filter<ObjectAssociation>)new JdoPrimaryKeyPropertyFilter());
    }

    public static boolean hasPrimaryKeyProperty(ObjectSpecification objectSpec) {
        return JdoPropertyUtils.getPrimaryKeyPropertyFor(objectSpec) != null;
    }

    private static OneToOneAssociation getPropertyFor(ObjectSpecification objSpec, String annotationName, Filter<ObjectAssociation> filter) {
        if (objSpec == null || !objSpec.containsFacet(JdoPersistenceCapableFacet.class)) {
            return null;
        }
        List propertyList = objSpec.getAssociations(Contributed.EXCLUDED, filter);
        if (propertyList.size() == 0) {
            return JdoPropertyUtils.getPropertyFor(objSpec.superclass(), annotationName, filter);
        }
        if (propertyList.size() > 1) {
            throw new IllegalStateException(MessageFormat.format("Shouldn''t have more than one property annotated with {0} (''{1}'')", annotationName, objSpec.getFullIdentifier()));
        }
        return (OneToOneAssociation)propertyList.get(0);
    }
}

