/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.objectstore.jdo.datanucleus.persistence.queries;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jdo.Query;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.services.container.query.QueryCardinality;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.OneToOneAssociation;
import org.apache.isis.core.runtime.persistence.query.PersistenceQueryFindUsingApplibQueryDefault;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.objectstore.jdo.datanucleus.metamodel.JdoPropertyUtils;
import org.apache.isis.objectstore.jdo.datanucleus.persistence.queries.PersistenceQueryProcessorAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceQueryFindUsingApplibQueryProcessor
extends PersistenceQueryProcessorAbstract<PersistenceQueryFindUsingApplibQueryDefault> {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceQueryFindUsingApplibQueryProcessor.class);

    public PersistenceQueryFindUsingApplibQueryProcessor(PersistenceSession persistenceSession) {
        super(persistenceSession);
    }

    @Override
    public List<ObjectAdapter> process(PersistenceQueryFindUsingApplibQueryDefault persistenceQuery) {
        String queryName = persistenceQuery.getQueryName();
        ObjectSpecification objectSpec = persistenceQuery.getSpecification();
        List<?> results = (objectSpec.getFullIdentifier() + "#pk").equals(queryName) ? this.getResultsPk(persistenceQuery) : this.getResults(persistenceQuery);
        return this.loadAdapters(results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<?> getResultsPk(PersistenceQueryFindUsingApplibQueryDefault persistenceQuery) {
        String queryName = persistenceQuery.getQueryName();
        Map<String, Object> map = PersistenceQueryFindUsingApplibQueryProcessor.unwrap(persistenceQuery.getArgumentsAdaptersByParameterName());
        ObjectSpecification objectSpec = persistenceQuery.getSpecification();
        Class cls = objectSpec.getCorrespondingClass();
        if (!JdoPropertyUtils.hasPrimaryKeyProperty(objectSpec)) {
            throw new UnsupportedOperationException("cannot search by primary key for DataStore-assigned entities");
        }
        OneToOneAssociation pkOtoa = JdoPropertyUtils.getPrimaryKeyPropertyFor(objectSpec);
        String pkOtoaId = pkOtoa.getId();
        String filter = pkOtoaId + "==" + map.get(pkOtoaId);
        Query jdoQuery = this.persistenceSession.newJdoQuery(cls, filter);
        jdoQuery.addExtension("datanucleus.multivaluedFetch", (Object)"none");
        if (LOG.isDebugEnabled()) {
            LOG.debug(cls.getName() + " # " + queryName + " ( " + filter + " )");
        }
        try {
            List results = (List)jdoQuery.execute();
            ArrayList arrayList = Lists.newArrayList((Iterable)results);
            return arrayList;
        }
        finally {
            jdoQuery.closeAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<?> getResults(PersistenceQueryFindUsingApplibQueryDefault persistenceQuery) {
        String queryName = persistenceQuery.getQueryName();
        Map<String, Object> argumentsByParameterName = PersistenceQueryFindUsingApplibQueryProcessor.unwrap(persistenceQuery.getArgumentsAdaptersByParameterName());
        QueryCardinality cardinality = persistenceQuery.getCardinality();
        ObjectSpecification objectSpec = persistenceQuery.getSpecification();
        Class cls = objectSpec.getCorrespondingClass();
        Query jdoQuery = this.persistenceSession.newJdoNamedQuery(cls, queryName);
        jdoQuery.addExtension("datanucleus.multivaluedFetch", (Object)"none");
        if (persistenceQuery.hasRange()) {
            jdoQuery.setRange(persistenceQuery.getStart(), persistenceQuery.getEnd());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(cls.getName() + " # " + queryName + " ( " + argumentsByParameterName + " )");
        }
        try {
            List results = (List)jdoQuery.executeWithMap(argumentsByParameterName);
            List resultsToReturn = cardinality == QueryCardinality.MULTIPLE ? results : (results.isEmpty() ? Collections.emptyList() : results.subList(0, 1));
            ArrayList arrayList = Lists.newArrayList(resultsToReturn);
            return arrayList;
        }
        finally {
            jdoQuery.closeAll();
        }
    }

    private static Map<String, Object> unwrap(Map<String, ObjectAdapter> argumentAdaptersByParameterName) {
        HashMap argumentsByParameterName = Maps.newHashMap();
        for (String parameterName : argumentAdaptersByParameterName.keySet()) {
            ObjectAdapter argumentAdapter = argumentAdaptersByParameterName.get(parameterName);
            Object argument = ObjectAdapter.Util.unwrap((ObjectAdapter)argumentAdapter);
            argumentsByParameterName.put(parameterName, argument);
        }
        return argumentsByParameterName;
    }
}

