/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime;

import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.config.IsisConfigurationBuilderDefault;
import org.apache.isis.core.runtime.RuntimeBootstrapper;
import org.apache.isis.core.runtime.optionhandler.OptionHandler;
import org.apache.isis.core.runtime.runner.IsisRunner;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerDeploymentTypeIsis;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerPassword;
import org.apache.isis.core.runtime.runner.opts.OptionHandlerUser;
import org.apache.isis.core.runtime.runner.opts.OptionValidatorUserAndPasswordCombo;

public class Isis {
    static final String DEFAULT_EMBEDDED_WEBSERVER = "jetty";

    public static void main(String[] args) {
        new Isis().run(args);
    }

    private void run(String[] args) {
        IsisRunner runner = new IsisRunner(args, new OptionHandlerDeploymentTypeIsis());
        this.addOptionHandlersAndValidators(runner);
        if (!runner.parseAndValidate()) {
            return;
        }
        runner.setConfigurationBuilder((IsisConfigurationBuilder)new IsisConfigurationBuilderDefault());
        runner.primeConfigurationWithCommandLineOptions();
        runner.loadInitialProperties();
        runner.bootstrap(new RuntimeBootstrapper());
    }

    private void addOptionHandlersAndValidators(IsisRunner runner) {
        OptionHandlerUser optionHandlerUser = new OptionHandlerUser();
        OptionHandlerPassword optionHandlerPassword = new OptionHandlerPassword();
        runner.addOptionHandler((OptionHandler)optionHandlerUser);
        runner.addOptionHandler((OptionHandler)optionHandlerPassword);
        runner.addValidator(new OptionValidatorUserAndPasswordCombo(optionHandlerUser, optionHandlerPassword));
    }
}

