/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.core.commons.lang.RunnableExtensions;
import org.apache.isis.core.runtime.installerregistry.InstallerLookup;
import org.apache.isis.core.runtime.installerregistry.installerapi.EmbeddedWebServerInstaller;
import org.apache.isis.core.runtime.runner.IsisBootstrapper;
import org.apache.isis.core.runtime.runner.IsisInjectModule;
import org.apache.isis.core.runtime.system.IsisSystem;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.viewer.IsisViewer;
import org.apache.isis.core.runtime.viewer.web.WebAppSpecification;
import org.apache.isis.core.runtime.web.EmbeddedWebServer;

final class RuntimeBootstrapper
implements IsisBootstrapper {
    RuntimeBootstrapper() {
    }

    @Override
    public void bootstrap(Injector injector) {
        this.bootstrapSystem(injector);
        this.bootstrapViewers(injector);
    }

    private void bootstrapSystem(Injector injector) {
        IsisSystem system = (IsisSystem)injector.getInstance(IsisSystem.class);
    }

    private void bootstrapViewers(Injector injector) {
        List<IsisViewer> viewers = this.lookupViewers(injector);
        List<IsisViewer> webViewers = this.findWebViewers(viewers);
        List<IsisViewer> nonWebViewers = this.findNonWebViewers(viewers, webViewers);
        this.startNonWebViewers(nonWebViewers);
        this.startWebViewers(injector, webViewers);
    }

    private List<IsisViewer> lookupViewers(Injector injector) {
        List<IsisViewer> viewers = ((IsisInjectModule.ViewerList)injector.getInstance(IsisInjectModule.ViewerList.class)).getViewers();
        InstallerLookup installerLookup = (InstallerLookup)injector.getInstance(InstallerLookup.class);
        IsisContext.setConfiguration(installerLookup.getConfiguration());
        return viewers;
    }

    private List<IsisViewer> findWebViewers(List<IsisViewer> viewers) {
        return Lists.newArrayList((Iterable)Iterables.filter(viewers, (Predicate)new Predicate<IsisViewer>(){

            public boolean apply(IsisViewer viewer) {
                return viewer.getWebAppSpecification() != null;
            }
        }));
    }

    private List<IsisViewer> findNonWebViewers(List<IsisViewer> viewers, List<IsisViewer> webViewers) {
        ArrayList<IsisViewer> nonWebViewers = new ArrayList<IsisViewer>(viewers);
        nonWebViewers.removeAll(webViewers);
        return nonWebViewers;
    }

    private void startNonWebViewers(List<IsisViewer> viewers) {
        for (final IsisViewer viewer : viewers) {
            Runnable target = new Runnable(){

                @Override
                public void run() {
                    viewer.init();
                }
            };
            RunnableExtensions.startThread((Runnable)target, (String)"Viewer");
        }
    }

    private void startWebViewers(Injector injector, List<IsisViewer> webViewers) {
        if (webViewers.size() == 0) {
            return;
        }
        InstallerLookup installerLookup = (InstallerLookup)injector.getInstance(InstallerLookup.class);
        EmbeddedWebServerInstaller webServerInstaller = installerLookup.embeddedWebServerInstaller("jetty");
        EmbeddedWebServer embeddedWebServer = webServerInstaller.createEmbeddedWebServer();
        for (IsisViewer viewer : webViewers) {
            WebAppSpecification webContainerRequirements = viewer.getWebAppSpecification();
            embeddedWebServer.addWebAppSpecification(webContainerRequirements);
        }
        embeddedWebServer.init();
    }
}

