/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.authentication.exploration;

import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.isis.core.commons.authentication.AuthenticationSessionAbstract;
import org.apache.isis.core.commons.encoding.DataInputExtended;
import org.apache.isis.core.commons.encoding.DataOutputExtended;
import org.apache.isis.core.commons.encoding.Encodable;
import org.apache.isis.core.commons.util.ToString;
import org.apache.isis.core.runtime.authentication.standard.SimpleSession;

public final class MultiUserExplorationSession
extends AuthenticationSessionAbstract
implements Encodable {
    private static final long serialVersionUID = 1L;
    private final Set<SimpleSession> sessions = new LinkedHashSet<SimpleSession>();
    private SimpleSession selectedSession;

    public MultiUserExplorationSession(Set<SimpleSession> sessions, String code) {
        super("unused", code);
        this.sessions.addAll(sessions);
        this.initialized();
    }

    public MultiUserExplorationSession(DataInputExtended input) throws IOException {
        super(input);
        this.sessions.addAll(Arrays.asList(input.readEncodables(SimpleSession.class)));
        this.selectedSession = (SimpleSession)input.readEncodable(SimpleSession.class);
        this.initialized();
    }

    public void encode(DataOutputExtended output) throws IOException {
        super.encode(output);
        output.writeEncodables(this.sessions.toArray());
        output.writeEncodable((Object)this.selectedSession);
    }

    private void initialized() {
        if (this.selectedSession == null && this.sessions.size() > 0) {
            this.selectedSession = this.sessions.iterator().next();
        }
    }

    public String getUserName() {
        return this.selectedSession.getUserName();
    }

    public boolean hasUserNameOf(String userName) {
        for (SimpleSession session : this.sessions) {
            if (!session.hasUserNameOf(userName)) continue;
            return true;
        }
        return false;
    }

    public List<String> getRoles() {
        return this.selectedSession.getRoles();
    }

    public void setCurrentSession(String name) {
        for (SimpleSession user : this.sessions) {
            if (!user.getUserName().equals(name)) continue;
            this.selectedSession = user;
            break;
        }
    }

    public Set<String> getUserNames() {
        LinkedHashSet<String> users = new LinkedHashSet<String>();
        for (SimpleSession user : this.sessions) {
            users.add(user.getUserName());
        }
        return users;
    }

    public String toString() {
        return new ToString((Object)this).append("name", this.getUserNames()).append("userCount", this.sessions.size()).toString();
    }
}

