/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.fixturedomainservice;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.runtime.fixturedomainservice.FixtureException;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.Persistor;

class LoadedObjects {
    private final Map<String, ObjectAdapter> idMap = new HashMap<String, ObjectAdapter>();
    private final Set<Object> objects;

    public LoadedObjects(Set<Object> objects) {
        this.objects = objects;
    }

    public ObjectAdapter get(String data) {
        int pos = data.indexOf(35);
        if (pos == -1) {
            throw new FixtureException("load failed - trying to read non-reference data as a reference: " + data);
        }
        String id = data.substring(pos + 1);
        ObjectAdapter object = this.idMap.get(id);
        if (object == null) {
            String className = data.substring(0, pos);
            ObjectSpecification specification = this.getSpecificationLoader().loadSpecification(className);
            object = this.getPersistenceSession().createTransientInstance(specification);
            this.idMap.put(id, object);
            this.objects.add(object.getObject());
        }
        return object;
    }

    protected Persistor getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    protected SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }
}

