/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.fixtures;

import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.runtime.fixtures.FixturesInstallerAbstract;
import org.apache.isis.core.runtime.fixtures.FixturesInstallerDelegate;
import org.apache.isis.core.runtime.fixtures.domainservice.ObjectLoaderFixture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FixturesInstallerFromConfiguration
extends FixturesInstallerAbstract {
    private static final Logger LOG = LoggerFactory.getLogger(FixturesInstallerFromConfiguration.class);
    private static final String NAKEDOBJECTS_FIXTURES = "isis.fixtures";
    private static final String NAKEDOBJECTS_FIXTURES_PREFIX = "isis.fixtures.prefix";
    private static final String EXPLORATION_OBJECTS = "isis.exploration-objects";

    public FixturesInstallerFromConfiguration() {
        super("configuration");
    }

    @Override
    protected void addFixturesTo(FixturesInstallerDelegate delegate) {
        String fixturePrefix = this.getConfiguration().getString(NAKEDOBJECTS_FIXTURES_PREFIX);
        String string = fixturePrefix = fixturePrefix == null ? "" : fixturePrefix.trim();
        if (fixturePrefix.length() > 0 && !fixturePrefix.endsWith(".")) {
            fixturePrefix = fixturePrefix + ".";
        }
        try {
            String[] fixtureList = this.getConfiguration().getList(NAKEDOBJECTS_FIXTURES);
            boolean fixtureLoaded = false;
            for (String element : fixtureList) {
                String fixtureFullyQualifiedName = fixturePrefix + element;
                LOG.info("  adding fixture " + fixtureFullyQualifiedName);
                Object fixture = InstanceUtil.createInstance((String)fixtureFullyQualifiedName);
                fixtureLoaded = true;
                delegate.addFixture(fixture);
            }
            if (this.getConfiguration().getBoolean(EXPLORATION_OBJECTS)) {
                delegate.addFixture(new ObjectLoaderFixture());
            }
            if (!fixtureLoaded) {
                LOG.warn("No fixtures loaded from configuration");
            }
        }
        catch (IllegalArgumentException e) {
            throw new IsisException((Throwable)e);
        }
        catch (SecurityException e) {
            throw new IsisException((Throwable)e);
        }
    }
}

