/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.fixtures;

import org.apache.isis.applib.profiles.Perspective;
import org.apache.isis.applib.profiles.Profile;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.runtime.fixtures.PerspectiveImpl;
import org.apache.isis.core.runtime.userprofile.PerspectiveEntry;
import org.apache.isis.core.runtime.userprofile.UserProfile;

class ProfileImpl
implements Profile {
    private final UserProfile userProfile = new UserProfile();

    public ProfileImpl(ProfileImpl profileTemplate) {
        this();
        this.userProfile.copy(profileTemplate.userProfile);
    }

    public ProfileImpl() {
    }

    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    public void addToOptions(String name, String value) {
        this.userProfile.addToOptions(name, value);
    }

    public void addToPerspectives(Perspective perspective) {
        this.userProfile.addToPerspectives(((PerspectiveImpl)perspective).getPerspectiveEntry());
    }

    public Perspective getPerspective(String name) {
        PerspectiveEntry perspectiveEntry = this.userProfile.getPerspective(name);
        if (perspectiveEntry == null) {
            throw new IsisException("No perspective found for " + name);
        }
        return new PerspectiveImpl(perspectiveEntry);
    }

    public Perspective newPerspective(String name) {
        PerspectiveEntry perspectiveEntry = this.userProfile.newPerspective(name);
        return new PerspectiveImpl(perspectiveEntry);
    }
}

