/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.installerregistry.installerapi;

import java.util.List;
import java.util.Properties;
import org.apache.isis.core.commons.config.InstallerAbstract;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.factory.InstanceUtil;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterFactory;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.services.ServicesInjectorDefault;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.runtime.installerregistry.InstallerLookup;
import org.apache.isis.core.runtime.installerregistry.InstallerLookupAware;
import org.apache.isis.core.runtime.installerregistry.installerapi.PersistenceMechanismInstaller;
import org.apache.isis.core.runtime.persistence.PersistenceSessionFactoryDelegating;
import org.apache.isis.core.runtime.persistence.adapter.PojoAdapterFactory;
import org.apache.isis.core.runtime.persistence.adaptermanager.AdapterManagerDefault;
import org.apache.isis.core.runtime.persistence.adaptermanager.PojoRecreator;
import org.apache.isis.core.runtime.persistence.adaptermanager.PojoRecreatorDefault;
import org.apache.isis.core.runtime.persistence.internal.RuntimeContextFromSession;
import org.apache.isis.core.runtime.persistence.objectstore.IsisObjectStoreLogger;
import org.apache.isis.core.runtime.persistence.objectstore.ObjectStoreSpi;
import org.apache.isis.core.runtime.persistence.objectstore.algorithm.PersistAlgorithm;
import org.apache.isis.core.runtime.persistence.objectstore.algorithm.PersistAlgorithmDefault;
import org.apache.isis.core.runtime.persistence.objectstore.transaction.TransactionalResource;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.AdapterManagerSpi;
import org.apache.isis.core.runtime.system.persistence.IdentifierGenerator;
import org.apache.isis.core.runtime.system.persistence.IdentifierGeneratorDefault;
import org.apache.isis.core.runtime.system.persistence.ObjectFactory;
import org.apache.isis.core.runtime.system.persistence.ObjectStore;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.core.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.core.runtime.systemdependencyinjector.SystemDependencyInjector;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistenceMechanismInstallerAbstract
extends InstallerAbstract
implements PersistenceMechanismInstaller,
InstallerLookupAware {
    private static final String LOGGING_PROPERTY = "isis.logging.persistenceSession";
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceMechanismInstallerAbstract.class);
    private SystemDependencyInjector installerLookup;

    public PersistenceMechanismInstallerAbstract(String name) {
        super("persistor", name);
    }

    public PersistenceMechanismInstallerAbstract(String type, String name) {
        super(type, name);
    }

    @Override
    public PersistenceSessionFactory createPersistenceSessionFactory(DeploymentType deploymentType) {
        return new PersistenceSessionFactoryDelegating(deploymentType, this.getConfiguration(), this);
    }

    @Override
    public PersistenceSession createPersistenceSession(PersistenceSessionFactory persistenceSessionFactory) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("installing " + this.getClass().getName());
        }
        ObjectAdapterFactory adapterFactory = persistenceSessionFactory.getAdapterFactory();
        ObjectFactory objectFactory = persistenceSessionFactory.getObjectFactory();
        PojoRecreator pojoRecreator = persistenceSessionFactory.getPojoRecreator();
        IdentifierGenerator identifierGenerator = persistenceSessionFactory.getIdentifierGenerator();
        ServicesInjectorSpi servicesInjector = persistenceSessionFactory.getServicesInjector();
        PersistAlgorithm persistAlgorithm = this.createPersistAlgorithm(this.getConfiguration());
        AdapterManagerDefault adapterManager = new AdapterManagerDefault(pojoRecreator);
        ObjectStoreSpi objectStore = this.createObjectStore(this.getConfiguration(), adapterFactory, adapterManager);
        Ensure.ensureThatArg((Object)persistAlgorithm, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)objectStore, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        if (this.getConfiguration().getBoolean(LOGGING_PROPERTY, false)) {
            String level = this.getConfiguration().getString("isis.logging.persistenceSession.level", "debug");
            objectStore = new IsisObjectStoreLogger(objectStore, level);
        }
        PersistenceSession persistenceSession = new PersistenceSession(persistenceSessionFactory, adapterFactory, objectFactory, servicesInjector, identifierGenerator, (AdapterManagerSpi)adapterManager, persistAlgorithm, (ObjectStore)objectStore);
        IsisTransactionManager transactionManager = this.createTransactionManager(persistenceSession, objectStore, servicesInjector);
        Ensure.ensureThatArg((Object)persistenceSession, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)transactionManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        persistenceSession.setDirtiableSupport(true);
        persistenceSession.setTransactionManager(transactionManager);
        return persistenceSession;
    }

    protected abstract ObjectStoreSpi createObjectStore(IsisConfiguration var1, ObjectAdapterFactory var2, AdapterManagerSpi var3);

    protected PersistAlgorithm createPersistAlgorithm(IsisConfiguration configuration) {
        return new PersistAlgorithmDefault();
    }

    protected IsisTransactionManager createTransactionManager(PersistenceSession persistenceSession, TransactionalResource transactionalResource, ServicesInjectorSpi servicesInjectorSpi) {
        return new IsisTransactionManager(persistenceSession, transactionalResource, servicesInjectorSpi);
    }

    public ClassSubstitutor createClassSubstitutor(IsisConfiguration configuration) {
        return (ClassSubstitutor)InstanceUtil.createInstance((String)"org.apache.isis.core.bytecode.cglib.CglibClassSubstitutor", ClassSubstitutor.class);
    }

    public void refineProgrammingModel(ProgrammingModel baseProgrammingModel, IsisConfiguration configuration) {
    }

    public void refineMetaModelValidator(MetaModelValidatorComposite baseMetaModelValidator, IsisConfiguration configuration) {
    }

    @Override
    public ObjectAdapterFactory createAdapterFactory(IsisConfiguration configuration) {
        return new PojoAdapterFactory();
    }

    @Override
    public ObjectFactory createObjectFactory(IsisConfiguration configuration) {
        return (ObjectFactory)InstanceUtil.createInstance((String)"org.apache.isis.core.bytecode.cglib.CglibObjectFactory", ObjectFactory.class);
    }

    @Override
    public ServicesInjectorSpi createServicesInjector(IsisConfiguration configuration) {
        return new ServicesInjectorDefault();
    }

    @Override
    public IdentifierGenerator createIdentifierGenerator(IsisConfiguration configuration) {
        return new IdentifierGeneratorDefault();
    }

    @Override
    public PojoRecreator createPojoRecreator(IsisConfiguration configuration) {
        return new PojoRecreatorDefault();
    }

    @Override
    public final RuntimeContext createRuntimeContext(IsisConfiguration configuration) {
        RuntimeContextFromSession runtimeContext = new RuntimeContextFromSession();
        Properties properties = PersistenceMechanismInstallerAbstract.applicationPropertiesFrom(configuration);
        runtimeContext.setProperties(properties);
        return runtimeContext;
    }

    private static Properties applicationPropertiesFrom(IsisConfiguration configuration) {
        Properties properties = new Properties();
        IsisConfiguration applicationConfiguration = configuration.getProperties("application");
        for (String key : applicationConfiguration) {
            String value = applicationConfiguration.getString(key);
            String newKey = key.substring("application.".length());
            properties.setProperty(newKey, value);
        }
        return properties;
    }

    @Override
    public void setInstallerLookup(InstallerLookup installerLookup) {
        this.installerLookup = installerLookup;
    }

    protected SystemDependencyInjector getInstallerLookup() {
        return this.installerLookup;
    }

    protected SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }

    public List<Class<?>> getTypes() {
        return PersistenceMechanismInstallerAbstract.listOf((Class[])new Class[]{PersistenceSessionFactory.class});
    }
}

