/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.installers;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.isis.core.commons.components.Installer;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.runtime.about.AboutIsis;
import org.apache.isis.core.runtime.about.ComponentDetails;

public class InstallerVersion
implements ComponentDetails {
    private final Installer installer;

    public InstallerVersion(Installer installer) {
        this.installer = installer;
    }

    public String getName() {
        return this.installer.getName();
    }

    public String getModule() {
        return "org.apache.isis.plugins:dndviewer";
    }

    public String getVersion() {
        return this.findVersion(this.getModule());
    }

    public boolean isInstalled() {
        return false;
    }

    private String findVersion(String moduleId) {
        try {
            String module = moduleId.replace(":", "/");
            InputStream resourceAsStream = AboutIsis.class.getClassLoader().getResourceAsStream("META-INF/maven/" + module + "/pom.properties");
            if (resourceAsStream == null) {
                return "no version";
            }
            Properties p = new Properties();
            p.load(resourceAsStream);
            String version = p.getProperty("version");
            return version;
        }
        catch (IOException e) {
            throw new IsisException((Throwable)e);
        }
    }
}

