/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.core.runtime.persistence;

import java.util.List;
import org.apache.isis.applib.DomainObjectContainer;
import org.apache.isis.applib.clock.Clock;
import org.apache.isis.applib.fixtures.FixtureClock;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.adapter.ObjectAdapterFactory;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.services.ServicesInjectorSpi;
import org.apache.isis.core.metamodel.spec.SpecificationLoaderSpi;
import org.apache.isis.core.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.apache.isis.core.metamodel.specloader.validator.MetaModelValidatorComposite;
import org.apache.isis.core.runtime.persistence.FixturesInstalledFlag;
import org.apache.isis.core.runtime.persistence.PersistenceSessionFactoryDelegate;
import org.apache.isis.core.runtime.persistence.adaptermanager.PojoRecreator;
import org.apache.isis.core.runtime.system.DeploymentType;
import org.apache.isis.core.runtime.system.context.IsisContext;
import org.apache.isis.core.runtime.system.persistence.IdentifierGenerator;
import org.apache.isis.core.runtime.system.persistence.ObjectFactory;
import org.apache.isis.core.runtime.system.persistence.PersistenceSession;
import org.apache.isis.core.runtime.system.persistence.PersistenceSessionFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class PersistenceSessionFactoryDelegating
implements PersistenceSessionFactory,
FixturesInstalledFlag {
    private final DeploymentType deploymentType;
    private final IsisConfiguration configuration;
    private final PersistenceSessionFactoryDelegate persistenceSessionFactoryDelegate;
    private DomainObjectContainer container;
    private List<Object> serviceList;
    private Boolean fixturesInstalled;
    private PojoRecreator pojoRecreator;
    private ObjectAdapterFactory adapterFactory;
    private ObjectFactory objectFactory;
    private IdentifierGenerator identifierGenerator;
    private ServicesInjectorSpi servicesInjector;
    private RuntimeContext runtimeContext;

    public PersistenceSessionFactoryDelegating(DeploymentType deploymentType, IsisConfiguration isisConfiguration, PersistenceSessionFactoryDelegate persistenceSessionFactoryDelegate) {
        this.deploymentType = deploymentType;
        this.configuration = isisConfiguration;
        this.persistenceSessionFactoryDelegate = persistenceSessionFactoryDelegate;
    }

    @Override
    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    public PersistenceSessionFactoryDelegate getDelegate() {
        return this.persistenceSessionFactoryDelegate;
    }

    @Override
    public PersistenceSession createPersistenceSession() {
        return this.persistenceSessionFactoryDelegate.createPersistenceSession(this);
    }

    public final void init() {
        Ensure.ensureThatState((Object)this.container, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatState(this.serviceList, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        if (!this.deploymentType.isProduction() && !Clock.isInitialized()) {
            FixtureClock.initialize();
        }
        this.pojoRecreator = this.persistenceSessionFactoryDelegate.createPojoRecreator(this.getConfiguration());
        this.adapterFactory = this.persistenceSessionFactoryDelegate.createAdapterFactory(this.getConfiguration());
        this.objectFactory = this.persistenceSessionFactoryDelegate.createObjectFactory(this.getConfiguration());
        this.identifierGenerator = this.persistenceSessionFactoryDelegate.createIdentifierGenerator(this.getConfiguration());
        Ensure.ensureThatState((Object)this.pojoRecreator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatState((Object)this.adapterFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatState((Object)this.objectFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatState((Object)this.identifierGenerator, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.servicesInjector = this.persistenceSessionFactoryDelegate.createServicesInjector(this.getConfiguration());
        Ensure.ensureThatState((Object)this.servicesInjector, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.runtimeContext = this.persistenceSessionFactoryDelegate.createRuntimeContext(this.getConfiguration());
        Ensure.ensureThatState((Object)this.runtimeContext, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.getSpecificationLoader().injectInto((Object)this.runtimeContext);
        this.runtimeContext.injectInto((Object)this.container);
        this.runtimeContext.setContainer(this.container);
        for (Object service : this.serviceList) {
            this.runtimeContext.injectInto(service);
        }
        this.servicesInjector.setContainer(this.container);
        this.servicesInjector.setServices(this.serviceList);
        this.servicesInjector.init();
    }

    public final void shutdown() {
        this.doShutdown();
    }

    protected void doShutdown() {
    }

    @Override
    public ObjectAdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    @Override
    public IdentifierGenerator getIdentifierGenerator() {
        return this.identifierGenerator;
    }

    @Override
    public ObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    @Override
    public PojoRecreator getPojoRecreator() {
        return this.pojoRecreator;
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public ServicesInjectorSpi getServicesInjector() {
        return this.servicesInjector;
    }

    public ClassSubstitutor createClassSubstitutor(IsisConfiguration configuration) {
        return this.persistenceSessionFactoryDelegate.createClassSubstitutor(configuration);
    }

    public void refineMetaModelValidator(MetaModelValidatorComposite metaModelValidator, IsisConfiguration configuration) {
        this.persistenceSessionFactoryDelegate.refineMetaModelValidator(metaModelValidator, configuration);
    }

    public void refineProgrammingModel(ProgrammingModel baseProgrammingModel, IsisConfiguration configuration) {
        this.persistenceSessionFactoryDelegate.refineProgrammingModel(baseProgrammingModel, configuration);
    }

    @Override
    public Boolean isFixturesInstalled() {
        return this.fixturesInstalled;
    }

    @Override
    public void setFixturesInstalled(Boolean fixturesInstalled) {
        this.fixturesInstalled = fixturesInstalled;
    }

    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public void setContainer(DomainObjectContainer container) {
        this.container = container;
    }

    @Override
    public void setServices(List<Object> serviceList) {
        this.serviceList = serviceList;
    }

    protected SpecificationLoaderSpi getSpecificationLoader() {
        return IsisContext.getSpecificationLoader();
    }
}

